#include "TixyTaxyTorxyCoordinate.h"

#include "TixyTaxyTorxy/TixyTaxyTorxyPrereqs.h"




namespace orxonox
{
    /**
    @brief
        Constructor. Sets the default coordinates: (0,0)
    */
    TixyTaxyTorxyCoordinate::TixyTaxyTorxyCoordinate()
    {
        Set(0,0);
    }

    TixyTaxyTorxyCoordinate::TixyTaxyTorxyCoordinate(int x, int y)
    {        
        Set(x,y);

    }

    void TixyTaxyTorxyCoordinate::Set(int x, int y)
    {        
        if (x < 0)
        {
            _x = 0;
        }
        else if (x > 10)
        {
            _x = 10;
        }
        else
        {
            _x = x;
        }

        if (y < 0)
        {
            _y = 0;
        }
        else if (y > 10)
        {
            _y = 10;
        }
        else
        {
            _y = y;
        }

        //Defniert die Positionen der einzelnen Minigames

        if( _x <= 2 && _y >= 8 ) _mini = 1;

        if( _x>= 4 &&_x <= 6 && _y >= 8 ) _mini = 2; 

        if( _x>= 8 && _y >= 8 ) _mini = 3; 

        if( _x <= 2 && _y >= 4 && _y<=6 ) _mini = 4; 

        if(_x>=4 &&_x <= 6 &&  _y>=4 &&_y <= 6 ) _mini = 5; 

        if( _x >=8 && _y >= 4 && _y<=6 ) _mini = 6; 

        if( _x <= 2 && _y <=2 ) _mini = 7; 

        if( _x >=4 &&_x <= 6 && _y <=2 ) _mini = 8;

        if( _x >= 8 && _y <=2 ) _mini = 9;  
    }

    int TixyTaxyTorxyCoordinate::GetX()
    {        
        return _x;
    }

    int TixyTaxyTorxyCoordinate::GetY()
    {        
        return _y;
    }
    int TixyTaxyTorxyCoordinate::Getmini()
    {        
        return _mini;
    }

    Vector3 TixyTaxyTorxyCoordinate::get3dcoordinate()
    {
        float tileScale = 100;

        Vector3 coord;
        coord.x= (_x-8) * tileScale;
        coord.y= (_y-8) * tileScale;
        coord.z=0;

        return coord;
    }
}
