/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */

/**
    @file TixyTaxyTorxy
TixyTaxyTorxyCenterpoint.cc
    @brief Implementation of the TixyTaxyTorxy
TixyTaxyTorxyCenterpoint class.
*/

#include "TixyTaxyTorxyCenterpoint.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "core/class/Super.h"

#include "TixyTaxyTorxy.h"

namespace orxonox
{
    RegisterClass(TixyTaxyTorxyCenterpoint);

    /**
    @brief
        Constructor. Registers and initializes the object and checks whether the gametype is actually TixyTaxyTorxy
TixyTaxyTorxy.
    */

TixyTaxyTorxyCenterpoint::TixyTaxyTorxyCenterpoint(Context* context) : MobileEntity(context)
    {
        RegisterObject(TixyTaxyTorxyCenterpoint);

        this->width_ = 10;
        this->height_ = 10;

        //this->setCollisionType(Static);

        this->checkGametype();

    }

    /**
    @brief
        Method to create a TixyTaxyTorxy
TixyTaxyTorxyCenterpoint through XML.
    */
    void TixyTaxyTorxyCenterpoint::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(TixyTaxyTorxyCenterpoint, XMLPort, xmlelement, mode);

        XMLPortParam(TixyTaxyTorxyCenterpoint, "width", setWidth, getWidth, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "height", setHeight, getHeight, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tileScale", setTileScale, getTileScale, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "selecterTemplate", setSelecterTemplate, getSelecterTemplate, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower1Template", setTower1Template, getTower1Template, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower2Template", setTower2Template, getTower2Template, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower3Template", setTower3Template, getTower3Template, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower4Template", setTower4Template, getTower4Template, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower5Template", setTower5Template, getTower5Template, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "fields", setFields, getFields, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower1Cost", setTower1Cost, getTower1Cost, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower2Cost", setTower2Cost, getTower2Cost, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower3Cost", setTower3Cost, getTower3Cost, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower4Cost", setTower4Cost, getTower4Cost, xmlelement, mode);
        XMLPortParam(TixyTaxyTorxyCenterpoint, "tower5Cost", setTower5Cost, getTower5Cost, xmlelement, mode);
    }

    /**
    @brief
        Checks whether the gametype is TixyTaxyTorxy
TixyTaxyTorxy and if it is, sets its centerpoint.
    */
    void TixyTaxyTorxyCenterpoint::checkGametype()
    {
        if (this->getGametype() != nullptr && this->getGametype()->isA(Class(TixyTaxyTorxy)))
        {
            // Sets the centerpoint of the gametype. The gametype uses this to later spawn in towers, he needs the tower template stored in the center point
            TixyTaxyTorxy* TixyTaxyTorxyGametype = orxonox_cast<TixyTaxyTorxy*>(this->getGametype());
            TixyTaxyTorxyGametype->setCenterpoint(this);
        }
    }

    /**
    @brief
        Removes all blanks, tabs and returns from the string passed.
    */
    void TixyTaxyTorxyCenterpoint::trimString(std::string* str)
    {
        std::string* trimmed = new std::string("");
        int length = str->size();
        char temp;
        for (int i = 0; i < length; ++ i)
        {
            temp = str->at(i);
            if (temp != ' ' && temp != '\t' && temp != '\n')
            {
                trimmed->push_back(temp);
            }
        }

        *str = *trimmed;
    }

    const int TixyTaxyTorxyCenterpoint::getTowerCost(int upgrade) const
    {
        return towerCosts_[(upgrade%5)];
    }
}
