/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *
 *   Co-authors:
 *      ...
 *
 */


#ifndef _TixyTaxyTorxy_H__
#define _TixyTaxyTorxy_H__
#include "TixyTaxyTorxyCoordinate.h"
#include "TixyTaxyTorxySelecter.h"
#include "TixyTaxyTorxy/TixyTaxyTorxyPrereqs.h"
#include "gametypes/TeamDeathmatch.h"
#include "util/Output.h"
#include "TixyTaxyTorxyField.h"

namespace orxonox
{
    /**
    @brief
    GameType class for TixyTaxyTorxy
TixyTaxyTorxy. See TixyTaxyTorxy
TixyTaxyTorxyReadme.txt for Information.

    @ingroup TixyTaxyTorxy
TixyTaxyTorxy
    */
    class _TixyTaxyTorxyExport TixyTaxyTorxy : public TeamDeathmatch
    {
    public:
        TixyTaxyTorxy(Context* context);
        virtual ~TixyTaxyTorxy();        
        virtual void start() override; //<! The function is called when the gametype starts
        virtual void end() override;
        virtual void tick(float dt) override;
        virtual void spawnPlayer(PlayerInfo* player) override;
        PlayerInfo* getPlayer(void) const;
        int getCredit(){ return this->credit_; }
        void payCredit(int pay){ this->credit_ -= pay; }
        int getLifes(){ return this->lifes_; }
        int getWaveNumber(){ return this->waveNumber_; }
        void setWaveNumber(int wavenumber){ waveNumber_=wavenumber; }
        void setCredit(int credit){ credit_ = credit; }
        void setLifes(int lifes){ lifes_ = lifes; }        
        void buyTower(int cost){ cost -= cost;}
        void addCredit(int credit) { credit_+=credit; }
        int reduceLifes(int NumberofLifes){ return lifes_-=NumberofLifes; }
        TixyTaxyTorxyField* getField(TixyTaxyTorxyCoordinate* coord){ return fields_[coord->GetX()][coord->GetY()]; }
        void setCenterpoint(TixyTaxyTorxyCenterpoint* centerpoint);        
        void addTower(int x, int y);
        void upgradeTower(int x, int y);
        int checkRow(int x, int y);
        int checkColumn(int x, int y);
        int checkMinigame(int x, int y);
        int checkDiagLtR(int x, int y);
        int checkDiagRtL(int x, int y);
        bool getPlayer2Value();
        bool getPlayer1Value();
        
        TixyTaxyTorxySelecter* selecter;        

    private:
        void createFields();

        orxonox::WeakPtr<TixyTaxyTorxyCenterpoint> center_;
        PlayerInfo* player_;
        float timeSinceLastSpawn_;
        float timeUntilNextWave_;
        int waveSize_;
        int credit_;
        int waveNumber_;
        int lifes_;
        bool player1;
        bool player2;
        TixyTaxyTorxyField* fields_[11][11];
        std::vector<orxonox::WeakPtr<TixyTaxyTorxyField>> waypoints_;
        Vector3 endpoint_;
        Vector3 offset_;        
    };
}

#endif /* _TixyTaxyTorxy
TixyTaxyTorxy_H__ */
