/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *  Author:
 *
 *   Co-authors:
 *      ...
 *
 *NACHRICHT:
 *
 * Hier empfehle ich euch die gesamte Spielogik unter zu bringen. Viele Funktionen werden automatisch
 * bei gewissen Ereignissen aufgerufen bzw. lösen Ereignisse aus
 *
 *Z.B:
 * start() //wird aufgerufen, bevor das Spiel losgeht
 * end() //wenn man diese Funktion aufruft wird
 * pawnKilled() // wird aufgerufen, wenn ein Pawn stirbt (z.B: wenn )
 * playerScored() // kann man aufrufen um dem Spieler Punkte zu vergeben.
 *
 *
 *TIPP: Eclipse hilft euch schnell auf bereits vorhanden Funktionen zuzugreifen:
 * einfach "this->" eingeben und kurz warten. Dann tauch eine Liste mit Vorschlägen auf. Wenn ihr jetzt weiter
 * tippt, werden die Vorschläge entsprechend gefiltert.
 *
 *
 *TIPP: schaut euch mal Tetris::createStone() an. Dort wird ein TetrisStone-Objekt (ControllableEntity) erzeugt,
 * ihm ein Template zugewiesen (welches vorher im Level definiert wurde und dem CenterPoint übergeben wurde)
 * Ähnlich könnt ihr vorgehen, um einen Turm zu erzeugen. (Zusätzlich braucht ein Turm noch einen Controller)
 * z.B: WaypointPatrolController. Wenn kein Team zugewiesen wurde bekämpft ein WaypointPatrolController alles,
 * was in seiner Reichweite liegt.
 *
 *
 *HUD:
 * Ein Gametype kann ein HUD (Head up Display haben.) Z.B: hat Pong eine Anzeige welcher Spieler wieviele Punkte hat.
 * Generell kann man a) Grafiken oder b) Zeichen in einer HUD anzeigen.
 * Fuer den ersten Schritt reicht reiner Text.
 *
 * a)
 * PongScore.cc uebernehmen und eigene Klasse draus machen.
 * Wenn ihr bloss anzeigen wollt wieviele Punkte der Spieler bereits erspielt hat (Punkte = Kapital fuer neue Tuerme) dann orientiert ihr euch an
 * TetrisScore.cc (im pCuts branch): http://www.orxonox.net/browser/code/branches/pCuts/src/modules/tetris/TetrisScore.cc
 * Ich habe TetrisScore lediglich dazu gebraucht, um eine Variable auf dem HUD auszugeben. Ein Objekt fuer statischen Text gibt es bereits.
 *
 * b)
 * Im naesten Schritt erstellt man die Vorlage fuer das HUD-Objekt: siehe /data/overlays/pongHUD
 * OverlayText ist eine Vorlage fuer statischen text zb: "Points Scored:". Aus mir nicht erklaerlichen Gruenden sollte man die OverlayText
 * Objekte immer erst nach dem PongScore anlegen.
 *
 * c)  Im TixyTaxyTorxy
TixyTaxyTorxy gamtype muss im Constructor noch das HUD-Template gesetzt werden.
 *
 * d) in CMakeLists.txt noch das Module includen das fuer die Overlays zustaendig ist. Siehe das gleiche File im Pong module.
 *
 *
 *
 */
#include "TixyTaxyTorxy.h"
#include "TixyTaxyTorxyTower.h"
#include "TixyTaxyTorxyCenterpoint.h"
#include "worldentities/SpawnPoint.h"
#include "controllers/WaypointController.h"
#include "graphics/Model.h"
#include "infos/PlayerInfo.h"
#include "chat/ChatManager.h"
#include "core/CoreIncludes.h"
#include "Highscore.h"
#include <iostream>
#include "TixyTaxyTorxyField.h"
using namespace std;

namespace orxonox
{

    RegisterUnloadableClass(TixyTaxyTorxy);



    
TixyTaxyTorxy::TixyTaxyTorxy(Context* context) : TeamDeathmatch(context)
    {
        RegisterObject(TixyTaxyTorxy);

        selecter = nullptr;
        this->player_ = nullptr;
        this->setHUDTemplate("TixyTaxyTorxyHUD");
        this->waveNumber_ = 0;
        this->timeSinceLastSpawn_ = 0.0;
        this->timeUntilNextWave_ = 0.0;
        this->credit_ = 0;
        this->lifes_ = 0;
        this->waveSize_ = 0;
        offset_ = Vector3(0,0,10);

    }

TixyTaxyTorxy::~TixyTaxyTorxy()
    {


        if (this->isInitialized())
        {

        }
    }

    void TixyTaxyTorxy::setCenterpoint(TixyTaxyTorxyCenterpoint *centerpoint)
    {
        this->center_ = centerpoint;
    }

    void TixyTaxyTorxy::start()
    {        
        if (center_ != nullptr) // There needs to be a TixyTaxyTorxyCenterpoint, i.e. the area the game takes place.
        {
            if (selecter == nullptr)
            {
                selecter = new TixyTaxyTorxySelecter(this->center_->getContext());                
            }
            selecter->addTemplate(center_->getSelecterTemplate());
            center_->attach(selecter);
        }
        else // If no centerpoint was specified, an error is thrown and the level is exited.
        {
            orxout(internal_error) << "Jump: No Centerpoint specified." << endl;
            return;
        }

        createFields();
        TeamDeathmatch::start();

        //set initial credits, lifes and WaveNumber
        this->setCredit(1000);
        this->setLifes(100);        
        this->timeSinceLastSpawn_ = 0.0;
        this->timeUntilNextWave_ = 5.0;
        this->waveSize_ = 0;
        this->setWaveNumber(0);
    }

   
    void TixyTaxyTorxy::end()
    {
        if (Highscore::exists())
        {
            int score = this->getWaveNumber();
            Highscore::getInstance().storeScore("Tower Defense", score, this->getPlayer());
        }
        TeamDeathmatch::end();
        ChatManager::message("Match is over! Gameover!");

    }

    void TixyTaxyTorxy::spawnPlayer(PlayerInfo* player)
    {
        assert(player);
        player_ = player;

        if (selecter->getPlayer() == nullptr)
        {
            player_->startControl(selecter);
            players_[player].state_ = PlayerState::Alive;
        } 
    }

    /**
    @brief
        Get the player.
    @return
        Returns a pointer to the player. If there is no player, nullptr is returned.
    */
    PlayerInfo* TixyTaxyTorxy::getPlayer(void) const
    {
        return this->player_;
    }

    //not working yet
    void TixyTaxyTorxy::addTower(int x,int y)
    {
        int mini;
         
        TixyTaxyTorxyCoordinate* coord = new TixyTaxyTorxyCoordinate(x,y);
        x = coord->GetX();
        y = coord->GetY();
        mini = coord->Getmini();

        orxout() <<"addTower("<<x<<", "<<y<<") "<<mini<<"" <<endl;
        int cost = center_->getTowerCost(1);

        if (fields_[x][y]->isFree())
        {
            payCredit(cost);
            fields_[x][y]->createTower(1);
        }
    
    bool player1=player2=0;
    int A1,B1,C1,D1,E1,F1,G1,H1,I1;
    int A2,B2,C2,D2,E2,F2,G2,H2,I2;
    A1=B1=C1=D1=E1=F1=G1=H1=I1=0;
    A2=B2=C2=D2=E2=F2=G2=H2=I2=0;



    if (checkMinigame(0,10) == 1) A1=1;
    if (checkMinigame(4,10) == 1) B1=2;
    if (checkMinigame(8,10) == 1) C1=4;
    if (checkMinigame(0,6) == 1) D1=8;
    if (checkMinigame(4,6) == 1) E1=16;
    if (checkMinigame(8,6) == 1) F1=32;
    if (checkMinigame(0,2) == 1) G1=64;
    if (checkMinigame(4,2) == 1) H1=128;
    if (checkMinigame(8,2) == 1) I1=256;

    if (checkMinigame(0,10) == 2) A2=1;
    if (checkMinigame(4,10) == 2) B2=2;
    if (checkMinigame(8,10) == 2) C2=4;
    if (checkMinigame(0,6) == 2) D2=8;
    if (checkMinigame(4,6) == 2) E2=16;
    if (checkMinigame(8,6) == 2) F2=32;
    if (checkMinigame(0,2) == 2) G2=64;
    if (checkMinigame(4,2) == 2) H2=128;
    if (checkMinigame(8,2) == 2) I2=256;

    orxout()<<"A1: "<<A1<<"B1: "<<B1<<endl;

    if(A1+B1+C1 == 7 || D1+E1+F1 == 56 || G1+H1+I1 == 448 || A1+D1+G1 == 73 || B1+E1+H1 == 146 || C1+F1+I1 == 294 || A1+E1+I1 == 273 || C1+E1+G1 == 84){

        player1=1;
        orxout()<<"player1 has won" << endl;
    }

     if(A2+B2+C2 == 7 || D2+E2+F2 == 56 || G2+H2+I2 == 448 || A2+D2+G2 == 73 || B2+E2+H2 == 146 || C2+F2+I2 == 294 || A2+E2+I2 == 273 || C2+E2+G2 == 84){

        player2=1;
        orxout()<<"player1 has won" << endl;
    }
    }

    int TixyTaxyTorxy::checkMinigame(int x, int y){
        if (checkRow(x,y)==1 || checkColumn(x,y)==1 || checkDiagLtR(x,y)==1 ||checkDiagRtL(x,y)==1) return 1;
        else if (checkRow(x,y)==2 || checkColumn(x,y)==2 || checkDiagLtR(x,y)==2 || checkDiagRtL (x,y)==2) return 2;
        return 0;
         }  

    int TixyTaxyTorxy::checkRow(int x, int y){
        for(int i=0; i<2; i++){

            if(fields_[x+i][y]-> isTower1() && fields_[x+i][y-1]-> isTower1() && fields_[x+i][y-2]-> isTower1()){
                return 1;

            }else if(fields_[x+i][y]-> isTower2() && fields_[x+i][y-1]-> isTower2() && fields_[x+i][y-2]-> isTower2()){
                return 2;}   
        }
        return 0;

    }
    int TixyTaxyTorxy::checkColumn(int x, int y){
        for(int i=0; i<2; i++){

            if(fields_[x][y-i]-> isTower1() && fields_[x+1][y-i]-> isTower1() && fields_[x+2][y-i]-> isTower1()){
                return 1;

            }else if (fields_[x][y-i]-> isTower2() && fields_[x+1][y-i]-> isTower2() && fields_[x+2][y-i]-> isTower2()){
            return 2;            }
        }
            return 0;
        
        
    }
    //Cheeck the diagonal achsis from top left to bottom right
    int TixyTaxyTorxy::checkDiagLtR(int x, int y){

        if (fields_[x][y]-> isTower1() && fields_[x+1][y-1]-> isTower1() && fields_[x+2][y-2]-> isTower1()){
            return 1;
        }
        else if (fields_[x][y]-> isTower2() && fields_[x+1][y-1]-> isTower2() && fields_[x+2][y-2]-> isTower2()){
            return 2;
        }
        return 0;
        
    }
    //Cheeck the diagonal achsis from top right to bottom left
    int TixyTaxyTorxy::checkDiagRtL (int x, int y){

        if(fields_[x+2][y]-> isTower1() && fields_[x+1][y-1]-> isTower1() && fields_[x][y-2]-> isTower1()){
            return 1;
        }
        else if(fields_[x+2][y]-> isTower2() && fields_[x+1][y-1]-> isTower2() && fields_[x][y-2]-> isTower2()){
            return 2;
        }
        
        else return 0;
        }

    bool TixyTaxyTorxy::getPlayer1Value(){
    return player1;
}
    bool TixyTaxyTorxy::getPlayer2Value(){
    return player2;
}
    






    /*adds Tower at Position (x,y) and reduces credit and adds the point to the towermatrix. template ("towerturret")
    so towers have ability if the turrets
    */

    void TixyTaxyTorxy::upgradeTower(int x, int y)
    {    
        // TixyTaxyTorxyCoordinate* coord = new TixyTaxyTorxyCoordinate(x,y);
        // x = coord->GetX();
        // y = coord->GetY();     

        // int cost = 100;

        // if (fields_[x][y]->isFree() == false && fields_[x][y]->canUpgrade() == true && getCredit() >= cost)
        // {
        //     payCredit(cost);
        //     fields_[x][y]->upgrade();
        // }
    }    

    void TixyTaxyTorxy::tick(float dt)
    {
        SUPER(TixyTaxyTorxy, tick, dt);

        if (hasStarted() == false || player_ == nullptr)
        {
            return;
        }
        timeUntilNextWave_ -= dt;
        timeSinceLastSpawn_ += dt;

        //build/upgrade tower at selecter position
        if (selecter != nullptr && selecter->buildTower_ == true)
        {
            selecter->buildTower_ = false;

            // if (getField(selecter->selectedPos_)->canUpgrade() == true)
            // {
            //     upgradeTower(selecter->selectedPos_->GetX(), selecter->selectedPos_->GetY());
            // }
            
            addTower(selecter->selectedPos_->GetX(), selecter->selectedPos_->GetY());
                    
        }
        

    }

    void TixyTaxyTorxy::createFields()
    {
        assert(center_);
        TixyTaxyTorxyCoordinate coord(0,0);
        TixyTaxyTorxyCoordinate startCoord(0,0);
        std::string fields = center_->getFields();
        int pos = 0;
        for (int j = 10; j >= 0; --j)
        {
            for (int i = 0; i < 11; ++i)
            {
                coord.Set(i,j);
                fields_[i][j] = new TixyTaxyTorxyField(center_->getContext());
                fields_[i][j]->setCenterpoint(center_);
                center_->attach(fields_[i][j]);
                fields_[i][j]->setPosition(coord.get3dcoordinate()); 
                fields_[i][j]->create(fields.at(pos), fields.at(pos+1));
                pos += 2;
                
            }
        }
    }
    
}
