/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      ...
 *
 */

/**
    @file OrxoKartTile.cc
    @brief Represents one Wall piece in the OrxoKart Game
*/

#include "OrxoKartTile.h"

#include "core/CoreIncludes.h"
#include "graphics/Model.h"
#include "objects/collisionshapes/BoxCollisionShape.h"

namespace orxonox
{
    RegisterClass(OrxoKartTile);

    OrxoKartTile::OrxoKartTile(Context* context) : StaticEntity(context)
    {
        RegisterObject(OrxoKartTile);

        this->model_ = nullptr;
        this->cs_ = nullptr;

        this->enableCollisionCallback();
        this->setCollisionResponse(true);
        this->setCollisionType(CollisionType::Static);
    }

    /**
    @brief
        Destructor.
    */
    OrxoKartTile::~OrxoKartTile()
    {
        if (this->isInitialized())
        {
            if (this->model_)
                this->model_->destroy();
            if (this->cs_)
                this->cs_->destroy();
        }
    }

    /**
    @brief
        Initializes a OrxoKartTile
    @param x
        x-Coordinate of the Square that the Wall is attached to, 0-9, Origin is Bottom left
    @param y
        y-Coordinate of the Square that the Wall is attached to, 0-9, Origin is Bottom left
    @param cellSize
        The size of a cell
    @param cellHeight
        The height of a cell
    @param orientation
            Wall on the right side (1) or on top (2) of this square, 0-1        
    */
    void OrxoKartTile::init(int x, int z, int s, int type)
    {
        model_ = new Model(this->getContext());
        if (type == 1) {
           model_->setMeshSource("OrxoKartStreckenabschnitt.mesh"); 
        }
        else if (type == 2 ) {
            model_->setMeshSource("OrxoKartStreckenabschnittZiel.mesh");
        }
        model_->setScale3D(Vector3(s*1.0f, 8.0f, s*1.0f));
        model_->setPosition(Vector3(x*1.0f, 0.0f, z*1.0f));

        this->attach(model_);

        cs_ = new BoxCollisionShape(this->getContext());
        cs_->setHalfExtents(Vector3(s/2.0f, 1.0f, s/2.0f));
        cs_->setPosition(Vector3(x*1.0f, -1.0f, z*1.0f));

        this->attachCollisionShape(cs_);

        /*

        int xSize_, zSize_, xPos_, zPos_;

        if(orientation == 1){
            xSize_ = cellSize/2;
            zSize_ = 2;
            zPos_ = x*cellSize;
            xPos_ = y*cellSize-cellSize/2;
        }
        else{
            xSize_ = 2;
            zSize_ = cellSize/2;
            zPos_ = x*cellSize-cellSize/2;
            xPos_ = y*cellSize;
        }


        model_ = new Model(this->getContext());
        model_->setMeshSource("CuboidBody.mesh");
        model_->setScale3D(Vector3(xSize_*1.0f, cellHeight*1.0f, zSize_*1.0f));
        model_->setPosition(Vector3(xPos_*1.0f, 0.0f, zPos_*1.0f));

        this->attach(model_);

        cs_ = new BoxCollisionShape(this->getContext());
        cs_->setHalfExtents(Vector3(xSize_*1.0f, cellHeight*1.0f, zSize_*1.0f));
        cs_->setPosition(Vector3(xPos_*1.0f, 0.0f, zPos_*1.0f));

        this->attachCollisionShape(cs_);
        */
    }
}
