/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Manuel Meier
 *   Co-authors:
 *      Cyrill Burgener
 *
 */

/**
    @file OrxoKart.cc
    @brief Implementation of the OrxoKart class. Sets up the whole Minigame
*/

#include "OrxoKart.h"

#include "OrxoKartOrigin.h"
#include "OrxoKartTile.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterUnloadableClass(OrxoKart);

    OrxoKart::OrxoKart(Context* context) : Gametype(context)
    {
        RegisterObject(OrxoKart);

        this->origin_ = nullptr;
        // this->numberOfFlags_ = 1;
        this->firstTick_ = true;

        this->setHUDTemplate("OrxoKartHUD");
    }

    void OrxoKart::tick(float dt)
    { 
        SUPER(OrxoKart, tick, dt);

        if(this->firstTick_ && this->origin_)
        {
            this->firstTick_ = false;

            int n = this->origin_->getNumCells();
            int s = this->origin_->getCellSize();
            int cellHeight = this->origin_->getCellHeight();

            int levelcodeArray[] =  {1,1,1,1,1,1,1,1,0,0,0
                                    ,1,0,0,0,0,0,0,1,1,1,0
                                    ,1,0,1,1,1,1,0,0,0,1,1
                                    ,1,1,1,0,0,1,1,0,0,0,1
                                    ,0,0,0,0,0,0,1,0,1,1,1
                                    ,1,1,1,1,1,1,1,0,1,0,0
                                    ,1,0,0,0,0,0,0,0,1,0,0
                                    ,1,0,0,0,0,0,0,0,1,0,0
                                    ,1,1,1,1,1,0,0,0,1,1,1
                                    ,0,0,0,0,1,0,0,0,0,0,1
                                    ,0,0,0,0,1,1,1,2,1,1,1};
            int* levelcode = levelcodeArray;


            //Generate floor according to levelcode
            for(int i=0; i<n; i++){
                for(int j=0; j<n; j++){
                    if (int type = levelcodeArray[i*n + j])
                    (new OrxoKartTile(origin_->getContext()))->init((n-1-i)*s, j*s, s, type);
                }   
            }

            

        }//firsttick end
            /*
        // Check if ship collided with one of the flags
        for ( unsigned int i = 0; i < flags_.size(); i++ ){
            if(flags_[i]->getCollided()){
                flags_[i]->destroyLater();
                flags_.erase (flags_.begin()+i);
            }
        }
        numberOfFlags_ = flags_.size(); */
        
    }
}
