/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *     Mauro Salomon
 *   Co-authors:
 *      Celine Egger*/
        



/*
Edited, Renewed and Revised by 
        Berkay Berabi
        Louis Meile
 
 
To-do- list by Louis Meile and Berkay Berabi for future projects :
- improve AI (SpaceRaceController): 
i) so far bots arent able to evade obstacles. fix that!
ii) bots should be able to use pickups
- game crashes when bot wins the game(this is a huge problem you should work with the log file to find out what the errors are )
- bots rotate while waiting for the countdown to end. make it stop!
- add elements to level file to make it even more fun to play. be creative!
*/


#include "SpaceRace.h"

#include "core/CoreIncludes.h"
#include "chat/ChatManager.h"
#include "util/Convert.h"
#include "util/Math.h"
#include "infos/Bot.h"
#include "items/Engine.h"
#include "controllers/HumanController.h"

#include "core/CoreIncludes.h"
#include "chat/ChatManager.h"
#include "infos/PlayerInfo.h"
#include "worldentities/pawns/Pawn.h"
#include "core/config/ConfigValueIncludes.h"
#include "infos/Bot.h"
#include "SpaceRaceBot.h"
#include "items/Engine.h"

#include "core/CoreIncludes.h"
#include "chat/ChatManager.h"
#include "util/Convert.h"
#include "util/Math.h"
#include "SpaceRaceBot.h"
#include "items/Engine.h"
#include <vector> 
#include <iostream>
#include <string>


namespace orxonox
{
    RegisterUnloadableClass(SpaceRace);

    SpaceRace::SpaceRace(Context* context) : Gametype(context)
    {
        RegisterObject(SpaceRace);

        this->botclass_ = Class(SpaceRaceBot);
        this->cantMove_ = false;
        this->bTimeIsUp_ = false;
        this->numberOfBots_ = 5; // quick fix: don't allow default-bots to enter the race 
        this->bLost =false;
        //we fixed the number of bots in order to have the same starting position all the time ! 
    }

    void SpaceRace::start()
    {
        // define spawn positions of the 5 bots

        float startpos[15];
        
        startpos[0] =100;
        startpos[1] =-40;
        startpos[2] =0;
        
        startpos[3] =100;
        startpos[4] =-40;
        startpos[5] =100;
         
        startpos[6] =100;
        startpos[7] =-40;
        startpos[8] =-100;
        
        startpos[9] =0;
        startpos[10] =-40;
        startpos[11] =-80;
        
        startpos[12] =0;
        startpos[13] =-40;
        startpos[14] =80;

        Gametype::start();

        this->spawnPlayersIfRequested();
        this->countdown_mode=true;
        this->cantMove_ = true;
        //players are unable to move while countdown is running
        for (Engine* engine : ObjectList<Engine>())
        {
            engine->setActive(false);
            engine->addSpeedMultiply(1.7);
        }

        //append spawn positions to bots
        int a,b,c;
        a=0;
        b=1;
        c=2;

        for (SpaceRaceBot* bot : ObjectList<SpaceRaceBot>())
        {
            bot->getControllableEntity()->setPosition(startpos[a], startpos[b], startpos[c]);
            a += 3;
            b += 3;
            c += 3;
        }

        std::string message("Use headphones to hear the countdown! Press W for forward acceleration, press W+space for boost!");

        this->getGametypeInfo()->sendAnnounceMessage(message);
        ChatManager::message(message);
        


        
    }

    // Counter in the beginning of the game
    void SpaceRace::tick(float dt) {
        SUPER(SpaceRace, tick, dt);
        
        //countdown_mode is set true,when spawnIfRequested is called
        if (countdown_mode) {
            //10 seconds will be counted
            this->time_passed -= dt;

            //orxout() << "time: " <<(int) time_passed << "s" << endl;

            std::string message=std::to_string((int)time_passed);
            this->getGametypeInfo()->sendAnnounceMessage(message);
            if (time_passed <= 1) {

                this->countdownFinished();
                this->countdown_mode = false;
            }
        }

    }
        
    void SpaceRace::startmessage(int second){

        std::string message=std::to_string(second);
        this->getGametypeInfo()->sendAnnounceMessage(message);
        ChatManager::message(message);
        
        

    }

    void SpaceRace::end()
    {
        
        this->clock_.capture();
        int s = this->clock_.getSeconds();
        int ms = static_cast<int>(this->clock_.getMilliseconds() - 1000*s);
        std::string message;
        if (this->bTimeIsUp_)
        {
            message = multi_cast<std::string>(s) + "." + multi_cast<std::string>(ms) + " seconds !!\n"
                        + "You loose!";
        }
       else if(this->bLost){
            message = multi_cast<std::string>(s)+"You could not reach the last checkpoint before your opponents. YOU LOOSE!";

       }        
       
        else
        {
            message = "You win!! Final check point reached after "+ multi_cast<std::string>(s)
                        + "." + multi_cast<std::string>(ms) + " seconds.";
        }
        
        if (!this->hasEnded())
        {

            this->getGametypeInfo()->sendAnnounceMessage(message);
            ChatManager::message(message);
        }
        this->Gametype::end();
    }

    void SpaceRace::newCheckpointReached(RaceCheckPoint* checkpoint, PlayerInfo* player)
    {
        this->checkpointReached_[player] = checkpoint;

        this->clock_.capture();
        int s = this->clock_.getSeconds();
        int ms = this->clock_.getMilliseconds() % 1000;

       
        std::string message(player->getName() + " reached the checkpoint " + multi_cast<std::string>(checkpoint->getCheckpointIndex() + 1) 
        + " after " + multi_cast<std::string>(s) + "." + multi_cast<std::string>(ms) + " seconds.");

        this->getGametypeInfo()->sendAnnounceMessage(message);
        ChatManager::message(message);
      /*  const std::string& message = player->getName() + " reached the checkpoint " + multi_cast<std::string>(checkpoint->getCheckpointIndex() + 1) 
        + "after " + multi_cast<std::string>(s) + "." + multi_cast<std::string>(ms) + " seconds.";
        this->getGametypeInfo()->sendAnnounceMessage(message);
        ChatManager::message(message);*/
        if(checkpoint->getCheckpointIndex()==19){
             const std::string& message = player->getName() + " reached the checkpoint " + multi_cast<std::string>(checkpoint->getCheckpointIndex() + 1) 
                + "after " + multi_cast<std::string>(s) + "." + multi_cast<std::string>(ms) + " seconds and WON THE GAME.";

        }

    }

    void SpaceRace::countdownFinished()//activates the engines of all players
    {

        std::string message("RACE STARTED ");
        this->getGametypeInfo()->sendAnnounceMessage(message);
        ChatManager::message(message);


        for (Engine* engine : ObjectList<Engine>())
            engine->setActive(true);
    }

    void SpaceRace::playerEntered(PlayerInfo* player)
    {
        Gametype::playerEntered(player);

        const std::string& message = player->getName() + " entered the game";
        ChatManager::message(message);
    }


    void SpaceRace::addBots(unsigned int amount) //function that add the bots to the game
    {
        for (unsigned int i = 1; i <= amount; ++i){
            this->botclass_.fabricate(this->getContext());
        }
    }


    //set bot configurations
    bool SpaceRace::allowPawnHit(Pawn* victim, Pawn* originator)
    {
        return true;
    }

    bool SpaceRace::allowPawnDamage(Pawn* victim, Pawn* originator)
    {
        return true;
    }

    bool SpaceRace::allowPawnDeath(Pawn* victim, Pawn* originator)// false because the bots can not recognize the objects and die to earlyif they can
    {
        return false;
    }
}
