/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Oli Scheuss
 *   Co-authors:
 *      Damian 'Mozork' Frick
 *
 */

#include "PacmanGhost.h"

#include "core/CoreIncludes.h"
#include "BulletDynamics/Dynamics/btRigidBody.h"

namespace orxonox
{
    RegisterClass(PacmanGhost);

    /**
    @brief
        Constructor. Registers the object and initializes some default values.
    @param creator
        The creator of this object.
    */
    PacmanGhost::PacmanGhost(Context* context) : ControllableEntity(context)
    {
        RegisterObject(PacmanGhost);

        this->velocity = Vector3(0, 0, 0);

        this->setCollisionType(CollisionType::Dynamic);
        
        this->actuelposition = this->getPosition();

        if(findpos(actuelposition, Vector3(0,-20,0)))
            dontmove = true;
        
        this->target_x = actuelposition.x;
        this->target_z = actuelposition.z; 

    }

    /**
    @brief
        Destructor. Destroys controller, if present.
    */
    PacmanGhost::~PacmanGhost()
    {
        // Deletes the controller if the object was initialized and the pointer to the controller is not NULL.
    }

    /**
    @brief
        Method for creating a AutonomousDrone through XML.
    */
    void PacmanGhost::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(PacmanGhost, XMLPort, xmlelement, mode);
    }



    Vector3 possibleposition[] = {Vector3(20,10,245),Vector3(215,10,245),Vector3(215,10,195),Vector3(185,10,195),Vector3(135,10,195), //0-4
        Vector3(185,10,150),Vector3(135,10,150),Vector3(215,10,150),Vector3(215,10,105),Vector3(135,10,105), //5-9
        Vector3(135,10,15),Vector3(135,10,-85),Vector3(215,10,-85),Vector3(135,10,-135),Vector3(215,10,-135), //10-14
        Vector3(215,10,-195),Vector3(135,10,-195),Vector3(20,10,195),Vector3(-20,10,195),Vector3(-20,10,245), //15-19
        Vector3(-215,10,245),Vector3(-215,10,195),Vector3(-185,10,195),Vector3(-135,10,195),Vector3(-70,10,195), //20-24
        Vector3(70,10,195),Vector3(70,10,150),Vector3(20,10,150),Vector3(-20,10,150),Vector3(-70,10,150), //25-29
        Vector3(-135,10,150),Vector3(-185,10,150),Vector3(-215,10,150),Vector3(-215,10,105),Vector3(-135,10,105), //30-34
        Vector3(-70,10,105),Vector3(-20,10,105),Vector3(20,10,105),Vector3(70,10,105),Vector3(70,10,60), //35-39
        Vector3(0,10,60),Vector3(-70,10,60),Vector3(-135,10,15),Vector3(-70,10,60),Vector3(0,10,15), //40-44
        Vector3(70,10,15),Vector3(-70,10,-35),Vector3(-20,10,-35),Vector3(20,10,-35),Vector3(70,10,-35), //45-49
        Vector3(70,10,-85),Vector3(20,10,-85),Vector3(-20,10,-85),Vector3(-70,10,-85),Vector3(-135,10,-85), //50-54
        Vector3(-215,10,-85),Vector3(-215,10,-135),Vector3(-135,10,-135),Vector3(-70,10,-135),Vector3(-20,10,-135), //55-59
        Vector3(20,10,-135),Vector3(70,10,-135),Vector3(20,10,-195),Vector3(-20,10,-195),Vector3(-135,10,-195), //60-64
        Vector3(-215,10,-195),Vector3(0,10,-35)}; //65-66

    /**
    @brief
        Defines which actions the AutonomousDrone has to take in each tick.
    @param dt
        The length of the tick.
    */
    void PacmanGhost::tick(float dt)
    {
        SUPER(PacmanGhost, tick, dt);

        //setorientation

        this->actuelposition = this->getPosition();
        
        //Stop, if target arrived
        if((abs(this->actuelposition.x - this->target_x)<0.5) && (abs(this->actuelposition.z - this->target_z)<0.5)){
                 this->ismoving = false;
        }

        //Move, if ghost hasn't arrived yet
        if(this->ismoving){
            if(!(abs(this->actuelposition.z-target_z)<0.5)) {
                velocity = Vector3(0,0,-sgn(this->actuelposition.z-this->target_z)*2);
                move(dt, actuelposition, velocity);
            }    
            if(!(abs(this->actuelposition.x-target_x)<0.5)){
                velocity = Vector3(-sgn(this->actuelposition.x-this->target_x)*2,0,0);
                move(dt, actuelposition, velocity);
            }
        }

        
        while(lock){};
        lock = true;
        //Check on which position ghost has arrived and set new target
         else{
            if(findpos(actuelposition,possibleposition[0])){
            	setnewTarget(1,17,19);
            }
            else if(findpos(actuelposition,possibleposition[1])){
            	setnewTarget(0,2);
            }
            else if(findpos(actuelposition,possibleposition[2])){
        		setnewTarget(1,3);
            }
            else if(findpos(actuelposition,possibleposition[3])){
			    setnewTarget(2,4,5);
            }
            else if(findpos(actuelposition,possibleposition[4])){
				setnewTarget(3,6);
            }
            else if(findpos(actuelposition,possibleposition[5])){
            	setnewTarget(3,7);
            }
            else if(findpos(actuelposition,possibleposition[6])){
                setnewTarget(4,9,26);
            }
            else if(findpos(actuelposition,possibleposition[7])){
                setnewTarget(5,8);
            }
            else if(findpos(actuelposition,possibleposition[8])){
                setnewTarget(7,9);
            }
            else if(findpos(actuelposition,possibleposition[9])){
                setnewTarget(6,8,10,38);
            }
            else if(findpos(actuelposition,possibleposition[10])){
                setnewTarget(9,11,45);
            }
            else if(findpos(actuelposition,possibleposition[11])){
                setnewTarget(10,12,13);
            }
            else if(findpos(actuelposition,possibleposition[12])){
                setnewTarget(11,14);
            }
            else if(findpos(actuelposition,possibleposition[13])){
                setnewTarget(11,14,16,61);
            }
            else if(findpos(actuelposition,possibleposition[14])){
                setnewTarget(12,13,15);
            }
            else if(findpos(actuelposition,possibleposition[15])){
                setnewTarget(14,16);
            }
            else if(findpos(actuelposition,possibleposition[16])){
                setnewTarget(13,15,62);
            }
            else if(findpos(actuelposition,possibleposition[17])){
                setnewTarget(0,25);
            }
            else if(findpos(actuelposition,possibleposition[18])){
                setnewTarget(19,24);
            }
            else if(findpos(actuelposition,possibleposition[19])){
                setnewTarget(0,18,20);
            }
            else if(findpos(actuelposition,possibleposition[20])){
                setnewTarget(19,21);
            }
            else if(findpos(actuelposition,possibleposition[21])){
                setnewTarget(20,22);
            }
            else if(findpos(actuelposition,possibleposition[22])){
                setnewTarget(21,23,31);
            }
            else if(findpos(actuelposition,possibleposition[23])){
                setnewTarget(22,30);
            }
            else if(findpos(actuelposition,possibleposition[24])){
                setnewTarget(18,29);
            }
            else if(findpos(actuelposition,possibleposition[25])){
                setnewTarget(17,26);
            }
            else if(findpos(actuelposition,possibleposition[26])){
                setnewTarget(6,25,27);
            }
            else if(findpos(actuelposition,possibleposition[27])){
                setnewTarget(26,28,37);
            }
            else if(findpos(actuelposition,possibleposition[28])){
                setnewTarget(27,29,36);
            }
            else if(findpos(actuelposition,possibleposition[29])){
                setnewTarget(24,28,30);
            }
            else if(findpos(actuelposition,possibleposition[30])){
                setnewTarget(23,29,34);
            }
            else if(findpos(actuelposition,possibleposition[31])){
                setnewTarget(22,32);
            }
            else if(findpos(actuelposition,possibleposition[32])){
                setnewTarget(31,33);
            }
            else if(findpos(actuelposition,possibleposition[33])){
                setnewTarget(32,34);
            }
            else if(findpos(actuelposition,possibleposition[34])){
                setnewTarget(30,33,35,42);
            }
            else if(findpos(actuelposition,possibleposition[35])){
                setnewTarget(34,36,41);
            }
            else if(findpos(actuelposition,possibleposition[36])){
                setnewTarget(28,35);
            }
            else if(findpos(actuelposition,possibleposition[37])){
                setnewTarget(27,38);
            }
            else if(findpos(actuelposition,possibleposition[38])){
                setnewTarget(9,37,39);
            }
            else if(findpos(actuelposition,possibleposition[39])){
                setnewTarget(38,40,45);
            }
            else if(findpos(actuelposition,possibleposition[40])){
                setnewTarget(39,41); //Shouldn't be able to return in center
            }
            else if(findpos(actuelposition,possibleposition[41])){
                setnewTarget(35,43);
            }
            else if(findpos(actuelposition,possibleposition[42])){
                setnewTarget(34,43,54);
            }
            else if(findpos(actuelposition,possibleposition[43])){
                setnewTarget(41,46);
            }
            else if(findpos(actuelposition,possibleposition[44])){
                setnewTarget(40,66);
            }
            else if(findpos(actuelposition,possibleposition[45])){
                setnewTarget(10,39,49);
            }
            else if(findpos(actuelposition,possibleposition[46])){
                setnewTarget(43,47);
            }
            else if(findpos(actuelposition,possibleposition[47])){
                setnewTarget(46,52,66);
            }
            else if(findpos(actuelposition,possibleposition[48])){
                setnewTarget(49,51,66);
            }
            else if(findpos(actuelposition,possibleposition[49])){
                setnewTarget(45,48);
            }
            else if(findpos(actuelposition,possibleposition[50])){
                setnewTarget(51,61);
            }
            else if(findpos(actuelposition,possibleposition[51])){
                setnewTarget(48,50);
            }
            else if(findpos(actuelposition,possibleposition[52])){
                setnewTarget(47,53);
            }
            else if(findpos(actuelposition,possibleposition[53])){
                setnewTarget(52,58);
            }
            else if(findpos(actuelposition,possibleposition[54])){
                setnewTarget(42,55,57);
            }
            else if(findpos(actuelposition,possibleposition[55])){
                setnewTarget(54,56);
            }
            else if(findpos(actuelposition,possibleposition[56])){
                setnewTarget(55,57,65);
            }
            else if(findpos(actuelposition,possibleposition[57])){
                setnewTarget(54,56,58,64);
            }
            else if(findpos(actuelposition,possibleposition[58])){
                setnewTarget(53,57,59);
            }
            else if(findpos(actuelposition,possibleposition[59])){
                setnewTarget(58,59,63);
            }
            else if(findpos(actuelposition,possibleposition[60])){
                setnewTarget(59,61,62);
            }
            else if(findpos(actuelposition,possibleposition[61])){
                setnewTarget(13,50,60);
            }
            else if(findpos(actuelposition,possibleposition[62])){
                setnewTarget(16,60);
            }
            else if(findpos(actuelposition,possibleposition[63])){
                setnewTarget(59,64);
            }
            else if(findpos(actuelposition,possibleposition[64])){
                setnewTarget(57,63,65);
            }
            else if(findpos(actuelposition,possibleposition[65])){
                setnewTarget(56,64);
            }
            else if(findpos(actuelposition,possibleposition[66])){
                setnewTarget(47,48);
            }

            else{
                this->resetGhost(); //Shouldn't happen...
            } //End of Position table

            }
            look = false;
    }

    void PacmanGhost::setnewTarget(int firstdec){
        
    	  decision = rand()%1;
            switch(decision){
                case 0:
                    this->target_x = possibleposition[firstdec].x;
                    this->target_z = possibleposition[firstdec].z; 
                    this->ismoving = true;
                    break;
    		}
    }

    void PacmanGhost::setnewTarget(int firstdec, int seconddec){ 
    	   decision = rand()%2;
            switch(decision){
                case 0:
                    this->target_x = possibleposition[firstdec].x;
                    this->target_z = possibleposition[firstdec].z; 
                    this->ismoving = true;
                    break;
                case 1:
                    this->target_x = possibleposition[seconddec].x;
                    this->target_z = possibleposition[seconddec].z; 
                    this->ismoving = true;
                    break;  
            }
            
    }

    void PacmanGhost::setnewTarget(int firstdec, int seconddec, int thirddec){
        
    	   decision = rand()%3;
            switch(decision){
                case 0:
                    this->target_x = possibleposition[firstdec].x;
                    this->target_z = possibleposition[firstdec].z; 
                    this->ismoving = true;
                    break;
                case 1:
                    this->target_x = possibleposition[seconddec].x;
                    this->target_z = possibleposition[seconddec].z; 
                    this->ismoving = true;
                    break;
                case 2:
                    this->target_x = possibleposition[thirddec].x;
                    this->target_z = possibleposition[thirddec].z; 
                    this->ismoving = true;
                    break;    
    		}
            
	}

    void PacmanGhost::setnewTarget(int firstdec, int seconddec, int thirddec, int fourthdec){
        
    	   decision = rand()%4;
            switch(decision){
                case 0:
                    this->target_x = possibleposition[firstdec].x;
                    this->target_z = possibleposition[firstdec].z; 
                    this->ismoving = true;
                    break;
                case 1:
                    this->target_x = possibleposition[seconddec].x;
                    this->target_z = possibleposition[seconddec].z; 
                    this->ismoving = true;
                    break;
                case 2:
                    this->target_x = possibleposition[thirddec].x;
                    this->target_z = possibleposition[thirddec].z; 
                    this->ismoving = true;
                    break;
                case 3:
                	this->target_x = possibleposition[fourthdec].x;
                    this->target_z = possibleposition[fourthdec].z; 
                    this->ismoving = true;
                    break;    
    		}
            
	}

    void PacmanGhost::changewith(PacmanGhost* otherghost){

        while(lock){};
        lock = true;

        otherghost->setPosition(this->getPosition());
        this->setPosition(0,-20,0);
        otherghost->target_x = this->target_x;   //Probleme bei parallelen Porzessen
        otherghost->target_z = this->target_z;
        otherghost->ismoving = this->ismoving;

        this->dontmove = true;
        otherghost->dontmove = false;

        lock = false;
    }


    void PacmanGhost::move(float dt, Vector3 actuelposition, Vector3 velocity){
        if(!dontmove)
            this->setPosition(Vector3(actuelposition.x+20*velocity.x*dt,10,actuelposition.z+20*velocity.z*dt));
    }

    bool PacmanGhost::findpos(Vector3 one, Vector3 other){
       if((abs(one.x - other.x)<0.5) && (abs(one.y - other.y)<0.5) && (abs(one.z - other.z)<0.5)) return true;
        return false;
    }

    void PacmanGhost::changemovability(){
        if(dontmove){
         dontmove = false;}
        else{
         dontmove = true;   
        }
    }

    void PacmanGhost::resetGhost(){
    
        this->setPosition(this->resetposition);
        this->ismoving = false;
        this->actuelposition = this->getPosition();
        
        this->target_x = actuelposition.x;
        this->target_z = actuelposition.z;
    
    }
}