/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Oli Scheuss
 *   Co-authors:
 *      Damian 'Mozork' Frick
 *
 */

#ifndef _PacmanGhost_H__
#define _PacmanGhost_H__

#include "OrxonoxPrereqs.h"

#include "core/XMLPort.h"

#include "worldentities/ControllableEntity.h"
//Test 
namespace orxonox {

    class _OrxonoxExport PacmanGhost : public ControllableEntity
    {
        public:
            PacmanGhost(Context* context);
            virtual ~PacmanGhost();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode); //!< Method for creating an AutonomousDrone through XML.
            virtual void tick(float dt); //!< Defines which actions the AutonomousDrone has to take in each tick.

            void move(float dt, Vector3 actuelposition, Vector3 velocity);
            
            void resetGhost();

            void setnewTarget(int firstdec);
            void setnewTarget(int firstdec, int seconddec);
            void setnewTarget(int firstdec, int seconddec, int thirddec);
            void setnewTarget(int firstdec, int seconddec, int thirddec, int fourthdec);


            bool findpos(Vector3 one, Vector3 other);      


        private:
            bool ismoving = false;
            int decision = 0; //Gives the random which way information to the ghost.
            int target_x = 0; 
            int target_z = 0; 
            Vector3 actuelposition;
            Vector3 velocity;
            Vector3 resetposition;
    };

}

#endif
