/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      ...
 *   Co-authors:
 *      ...
 *
 */

#include "DialogManager.h"
#include "core/CoreIncludes.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include <string>

namespace orxonox {
	ManageScopedSingleton(DialogManager, ScopeID::ROOT, false);
	

	
	DialogManager::DialogManager()
	{
		this->currentTalk_ = nullptr;
		this->answerIds_ = nullptr;
	}

	void DialogManager::setDialog(Dialog* dialog)
	{
		this->currentTalk_ = dialog;
		this->answerIds_ = &this->currentTalk_->getAnswerIds();
	}

	//from here onward funcionality for lua axports

    std::string DialogManager::getQuestion()
    {
    	return this->currentTalk_->getQuestionString();
    }

    int DialogManager::getSize()
    {   
        return this->answerIds_->size();
    }

    std::string DialogManager::getAnswer(int index)
    {
    	return this->currentTalk_->getAnswerString(this->answerIds_->at(index));
    }
	
    std::string DialogManager::getPerson()
    {
    	return this->currentTalk_->getName();
    }

    bool DialogManager::endtest(int index)
    {   
        if(this->answerIds_->empty())
        {
            return true;
        }
        else 
        {
            return this->currentTalk_->ending(this->answerIds_->at(index));
        }

    }

    void DialogManager::update(int index)
    {
    	this->currentTalk_->update(this->answerIds_->at(index));
    	this->answerIds_ = &this->currentTalk_->getAnswerIds();
    }
}
