/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  S
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Nikola Bolt
 *   Co-authors:
 *      Claudio Fanconi
 *
 */

#ifndef _StoryModeHUD_H__
#define _StoryModeHUD_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <string>

#include "util/OgreForwardRefs.h"
#include "tools/interfaces/Tickable.h"
#include "overlays/OrxonoxOverlay.h"

namespace orxonox
{
    class _OverlaysExport StoryModeHUD : public OrxonoxOverlay, public Tickable
    {
    public:
            StoryModeHUD(Context* context);
            virtual ~StoryModeHUD();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void tick(float dt) override;

        private:
            void initialize();

            void setTextSize(float size);
            float getTextSize() const;

            void setFont(const std::string& font);
            const std::string& getFont() const;

            std::vector<Ogre::TextAreaOverlayElement*> texts;
            std::string fontName_;
            float textSize_;
            bool firstTick = true;
   
    };
}

#endif /* _StoryModeHUD_H__ */
