#ifndef _NextQuestion_H__
#define _NextQuestion_H__



#include <string>
#include "core/class/Identifier.h"
#include "OrxonoxPrereqs.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"
#include "DialoguePrereqs.h"


namespace orxonox{
    class _DialogueExport NextQuestion : public BaseObject
    {

        //tolua_begin
        public:

        NextQuestion (Context* context); // tolua_export


        void setquestion(std::string question);
        std::string getquestion(void);

        void setanswers1(std::string a1);
        void setanswers2(std::string a2);
        std::string getanswers1(void);
        std::string getanswers2(void);




        //XMLEventPort for Event that first triggers the Dialogue
        virtual void XMLEventPort(Element& xmlelement, XMLPort::Mode mode);

        //XMLPort for setting questions and answers and the vector possibleQuestions
        virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

        bool addposQuestion(NextQuestion* nq);
        const NextQuestion* getposQuestion(unsigned int index) const;

        //Sets very first currentQuestion in the DialogueManager when the event is triggered
        bool execute(bool bTriggered, BaseObject* trigger);

        std::vector<NextQuestion*> possibleQuestions;

    private:
        std::string a1;
        std::string a2;



        std::string question;
        DialogueManager* m;

    };

}
#endif
