//#include <vector>
#include <string>
#include "core/CoreIncludes.h"
#include "core/GUIManager.h"
#include "overlays/OrxonoxOverlay.h"


#include "NextQuestion.h"
#include "core/XMLPort.h"
#include "DialogueManager.h"

namespace orxonox{

    RegisterClass(NextQuestion);

    NextQuestion::NextQuestion(Context* context) : BaseObject(context)
    {
        RegisterObject(NextQuestion);

        DialogueManager& m = DialogueManager::getInstance();
        m.registerquestion(this);
       
        
    }

    void NextQuestion::setquestion(std::string question){
        this->question=question;
    }

    std::string NextQuestion::getquestion(void){
        return question;
    }


    bool NextQuestion::addposQuestion(NextQuestion* nq){

        possibleQuestions.push_back(nq);
        return true;
    }

    const NextQuestion* NextQuestion::getposQuestion(unsigned int i) const
    {
        for (NextQuestion* effect : this->possibleQuestions)
        {
            if(i == 0)
               return effect;
            i--;
        }
        return nullptr;
         }


    void NextQuestion::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(NextQuestion, XMLPort, xmlelement, mode);

        XMLPortParam(NextQuestion, "question", setquestion, getquestion, xmlelement, mode);
        XMLPortParam(NextQuestion, "a1", setanswers1, getanswers1, xmlelement, mode);
        XMLPortParam(NextQuestion, "a2", setanswers2, getanswers2, xmlelement, mode);
        XMLPortObject(NextQuestion, NextQuestion, "possibleQuestions", addposQuestion, getposQuestion, xmlelement, mode);
       
    }
    bool NextQuestion::execute(bool bTriggered, BaseObject* trigger)
    {  
        
        DialogueManager& m = DialogueManager::getInstance();

        m.setquestion(question);
        m.setCurrentQuestion(this);
        m.setanswers1(a1);
        m.setanswers2(a2);
       

       
        OrxonoxOverlay::showOverlay("Dialogue");

        return false;
    }

    void NextQuestion::XMLEventPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(NextQuestion, XMLEventPort, xmlelement, mode);

        XMLPortEventSink(NextQuestion, BaseObject, "execute", execute, xmlelement, mode); 
    }


    void NextQuestion::setanswers1(std::string a1){
        this->a1=a1;
    }

    void NextQuestion::setanswers2(std::string a2){
        this->a2=a2;
    }



    std::string NextQuestion::getanswers1(void){
        return a1;
    }

    std::string NextQuestion::getanswers2(void){
        return a2;
    }

}
