#include "core/CoreIncludes.h"
#include "core/LuaState.h"
#include "core/GUIManager.h"
#include "core/class/Identifier.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "network/Host.h"
#include "network/NetworkFunctionIncludes.h"
#include "DialogueManager.h"
#include <vector>
#include <string>
#include "core/XMLPort.h"
#include "NextQuestion.h"



namespace orxonox {
    ManageScopedSingleton(DialogueManager, ScopeID::ROOT, false);
    
    DialogueManager::DialogueManager(){}

    void DialogueManager::registerquestion(NextQuestion* nq){
        if(allQuestions.size()==0) {
            orxout(internal_info) << "At least one NextQuestion has to be set." << endl;
        }
        allQuestions.push_back(nq);
        orxout(internal_info) << "qsize " << allQuestions.size();

    }

    void DialogueManager::setquestion(std::string q){
        question=q;

    }
    void DialogueManager::setCurrentQuestion(NextQuestion* nq){
        currentQuestion=nq;

    }

    std::string DialogueManager::getquestion(void){
        return question;
    }

    void DialogueManager::setanswers1(std::string a1){
        this->a1=a1;
    }

    void DialogueManager::setanswers2(std::string a2){
        this->a2=a2;
    }



    std::string DialogueManager::getanswers1(void){
        return a1;
    }

    std::string DialogueManager::getanswers2(void){
        return a2;
    }

    void DialogueManager::a1clicked(void){

        currentQuestion = currentQuestion->possibleQuestions[0];
        update(currentQuestion);


    }
    void DialogueManager::a2clicked(void){

        currentQuestion = currentQuestion->possibleQuestions[1];
        update(currentQuestion);
    }

    void DialogueManager::update(NextQuestion* nq){
        this->setquestion(nq->getquestion());
        this->setanswers1(nq->getanswers1());
        this->setanswers2(nq->getanswers2());
    }

    bool DialogueManager::theEnd(){
        if((currentQuestion->possibleQuestions).empty())
            return true;
        else
            return false;
    }

}
