#include <string>
#include <vector>

#include "OrxonoxPrereqs.h"
#include "core/config/Configurable.h"
#include "util/Singleton.h"

// tolua_begin
namespace orxonox
{
class _OrxonoxExport Highscore 
// tolua_end
 : public Singleton<Highscore>, public Configurable
{ //tolua_export
    friend class Singleton<Highscore>;
    public:
        Highscore();              // Constructor
        void setConfigValues(); // Inherited function

        void storeScore(const std::string& level, int points, PlayerInfo* player);
        int getHighestScoreOfGame(const std::string& game);

        // tolua_begin
        inline unsigned int getNumberOfHighscores()
            { return this->highscores_.size(); }
        inline const std::string& getHighscore(unsigned int index)
            { return this->highscores_[index]; }

        static Highscore& getInstance()
            { return Singleton<Highscore>::getInstance(); }
        // tolua_end 

    private:
        std::vector<std::string> highscores_;
        static Highscore* singletonPtr_s;
}; //tolua_export


} //tolua_export
