#include "Highscore.h"

#include "core/CoreIncludes.h"
#include "core/config/ConfigValueIncludes.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "infos/PlayerInfo.h"
#include "util/Convert.h"

namespace orxonox
{
    ManageScopedSingleton(Highscore, ScopeID::ROOT, false);
	RegisterClassNoArgs(Highscore);

	Highscore::Highscore()
    {
        RegisterObject(Highscore);
        this->setConfigValues();
    }

    /**
     * @brief set the config values in the orxonox.ini file
     */
    void Highscore::setConfigValues()
    {
        SetConfigValue(highscores_, std::vector<std::string>()).description("Highscores saved as vector");
    }

    /**
     * @brief Returns highest score of given game, if exists.
     * Else returns -1.
     */
    int Highscore::getHighestScoreOfGame(const std::string& game){
        const std::string delimiter = "./."; //score save as "Playername./.game./.score"
        int best = -1;
        //check for the highest Score of given game
        for (std::string score : this->highscores_)
        {
            //filter the game string from given highscore
            score.erase(0, score.find(delimiter) + delimiter.length());
            if(game.compare(score.substr(0,score.find(delimiter))) == 0){
                score.erase(0, score.find(delimiter) + delimiter.length());
                int possibleBest = multi_cast<int>(score);
                if(possibleBest > best) best = possibleBest;
            }
        }
        
        return best;
        
    }

    /**
     * @brief stores a new highscore in the orxonox.ini file
     */
    void Highscore::storeHighscore(const std::string& level, int points, PlayerInfo* player){
        ModifyConfigValue(highscores_, add, player->getName() + "./." + level + "./." + multi_cast<std::string>(points));
    }
}
