/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Patrick Wintermeyer
 *   Co-authors:
 *      ...
 *
 */

#include <vector>
#include <string>

#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h>

#include "core/CoreIncludes.h"
#include "core/class/Super.h"
#include "util/StringUtils.h"
#include "HUDPickupSystem.h"
#include "HUDPickupItem.h"
#include "pickup/PickupManager.h"

namespace orxonox
{
    RegisterClass(HUDPickupSystem);

    HUDPickupSystem::HUDPickupSystem(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDPickupSystem);

        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "HUDPickupSystem" + getUniqueNumberString()));
        overlayElement_->setMaterialName("PickupBar");
        overlayElement_->setPosition(0.0f,0.0f);
        overlayElement_->setDimensions(0.70f,0.15f);
        this->background_->addChild(overlayElement_);
    }

    HUDPickupSystem::~HUDPickupSystem()
    {
    }

    void HUDPickupSystem::sizeChanged()
    {
        OrxonoxOverlay::sizeChanged();

    }
    
    void HUDPickupSystem::tick(float dt)
    {
        SUPER(HUDPickupSystem, tick, dt);

        //hide all pickup symbols in HUD and delete from local map
        for(HUDPickupItem* item : items_)
        {
            item->hideMe();
        }

        items_.clear();
        assert(items_.empty()); //items_ must be empty now

        //add to local map and place on screen
        const float offsetX = 0.345f;
        const float offsetY = 0.82f;
        const float x = 0.102f;
        const float y = 0.075f;

        int numPickups = PickupManager::getInstance().getNumPickups();
        for (int index = 0; index < numPickups; ++index)
        {
            int row = index / 5;
            int column = index % 5;

            const PickupInventoryContainer* container = PickupManager::getInstance().popPickup();

            HUDPickupItem* item = new HUDPickupItem(this->getContext());
            item->initializeMaterial(this->getIcon(container->representationName), offsetX+column*x, offsetY+row*y);
            item->setOverlayGroup(this->getOverlayGroup());
            items_.push_back(item);
        }
    }

    std::string HUDPickupSystem::getIcon(std::string repName)
    {
        if(repName.find("invisible", 0)!=std::string::npos) return "Eye";
        else if(repName.find("tri", 0)!=std::string::npos) return "Asterisk";
        else if(repName.find("health", 0)!=std::string::npos || repName.find("Health", 0)!=std::string::npos) return "Cross";
        else if(repName.find("shield", 0)!=std::string::npos) return "Shield";
        else if(repName.find("munition", 0)!=std::string::npos) return "Munition";
        else if(repName.find("shrink", 0)!=std::string::npos) return "Shrink";
        else if(repName.find("boost", 0)!=std::string::npos) return "Flash";
        else if(repName.find("speed", 0)!=std::string::npos) return "3arrowsup";
        else if(repName.find("drone", 0)!=std::string::npos) return "Damage";
        else return "Unknown";
    }
}
