/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Patrick Wintermeyer
 *   Co-authors:
 *      ...
 *
 */

#include <vector>
#include <string>

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "core/class/Super.h"
#include "HUDPickupSystem.h"
#include "pickup/Pickup.h"
#include "HUDPickupItem.h"
#include "pickup/PickupManager.h"

namespace orxonox
{
    RegisterClass(HUDPickupSystem);

    HUDPickupSystem::HUDPickupSystem(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDPickupSystem);

        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", "HUDPickupSystem" + getUniqueNumberString()));
        overlayElement_->setMaterialName("PickupBar");
        overlayElement_->setPosition(0.0f,0.0f);
        overlayElement_->setDimensions(0.70f,0.15f);
        this->background_->addChild(overlayElement_);
    }

    HUDPickupSystem::~HUDPickupSystem()
    {
    }

    void HUDPickupSystem::sizeChanged()
    {
        OrxonoxOverlay::sizeChanged();

    }
    
    void HUDPickupSystem::sync(std::vector<Pickupable*> p, std::map<Pickupable*, uint32_t> indexes_)
    {
        //hide all pickup symbols in HUD and delete from local map
        
        for(const auto& sm_pair : picks)
        {
            sm_pair.second->hideMe(sm_pair.first, repaint);
        }

        picks.clear();
        assert(picks.empty()); //picks must be empty now

        //add to local map and place on screen
        int i = 0;
        const float offsetX = 0.345f;
        float offsetY = 0.82f;
        const float x = 0.102f;

        for(Pickupable* pickup:p)
        {
            i=indexes_.find(pickup)->second;
            //second row has offset
            if(i==5)
            {    
                i=0;
                offsetY+=0.075f;
            }

            HUDPickupItem* item = new HUDPickupItem(this->getContext());
            item->initializeMaterial(this->getIcon(((Pickup*)pickup)->getRepresentationName()), offsetX+i*x, offsetY);
            item->setOverlayGroup(this->getOverlayGroup());
            picks[pickup] = item;
        }
    }

    
    void HUDPickupSystem::destroyAll()
    {
        this->background_->removeChild(overlayElement_->getName());
    }

    std::string HUDPickupSystem::getIcon(std::string repName)
    {
        if(repName.find("invisible", 0)!=std::string::npos) return "Eye";
        else if(repName.find("tri", 0)!=std::string::npos) return "Asterisk";
        else if(repName.find("health", 0)!=std::string::npos || repName.find("Health", 0)!=std::string::npos) return "Cross";
        else if(repName.find("shield", 0)!=std::string::npos) return "Shield";
        else if(repName.find("munition", 0)!=std::string::npos) return "Munition";
        else if(repName.find("shrink", 0)!=std::string::npos) return "Shrink";
        else if(repName.find("boost", 0)!=std::string::npos) return "Flash";
        else if(repName.find("speed", 0)!=std::string::npos) return "3arrowsup";
        else if(repName.find("drone", 0)!=std::string::npos) return "Damage";
        else return "Unknown";
    }
}
