/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Patrick Wintermeyer
 *   Co-authors:
 *      ...
 *
 */


#ifndef _HUDPickupSystem_H__
#define _HUDPickupSystem_H__

#include "overlays/OverlaysPrereqs.h"

#include <map>
#include <vector>
#include <string>


#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h> 

#include "overlays/OrxonoxOverlay.h"
#include "worldentities/pawns/Pawn.h"
#include "overlays/OverlayGroup.h"
#include "pickup/Pickup.h"
#include "pickup/PickupRepresentation.h"
#include "HUDPickupItem.h"

namespace orxonox
{
    class _OverlaysExport HUDPickupSystem : public OrxonoxOverlay
    {
    public:
        HUDPickupSystem(Context* context);
        virtual ~HUDPickupSystem();

        void sizeChanged();
        void sync(std::vector<Pickupable*> p, std::map<Pickupable*, uint32_t> indexes_);

        bool repaint=true; //if we shouldnt repaint, set this to false

    private:
        
        void destroyAll();
        std::string getIcon(std::string repName);

        std::map<Pickupable*, HUDPickupItem*> picks;

        Ogre::PanelOverlayElement* overlayElement_;
        WeakPtr<Pawn> owner_;

        std::vector<PickupRepresentation> pickupRepresentations_;
    };
}

#endif