/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Patrick Wintermeyer
 *   Co-authors:
 *      ...
 *
 */

#include "HUDPickupItem.h"

#include <string>


#include <OgreOverlayManager.h>
#include <OgrePanelOverlayElement.h> 

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "util/Convert.h"
#include "core/class/Super.h"
#include "HUDPickupItem.h"

namespace orxonox
{
    RegisterClass(HUDPickupItem);

    HUDPickupItem::HUDPickupItem(Context* context) : OrxonoxOverlay(context)
    {
        RegisterObject(HUDPickupItem);

        std::string name = "HUDPickupItem" + getUniqueNumberString();
        orxout() << "name: "<< name<<endl;
        overlayElement_ = static_cast<Ogre::PanelOverlayElement* >(Ogre::OverlayManager::getSingleton().createOverlayElement("Panel", name ));

        overlayElement_->setDimensions(0.075f,0.08f);
        
    }

    HUDPickupItem::~HUDPickupItem()
    {
        /*if (this->isInitialized())
        {
            overlayElement_=nullptr;
        }*/
    }

    void HUDPickupItem::initializeMaterial(const std::string& s, float x, float y)
    {
        overlayElement_->setMaterialName(s);
        overlayElement_->setPosition(x, y);
        overlayElement_->show();
        this->background_->addChild(overlayElement_);
    }

    void HUDPickupItem::hideMe(Pickupable* p, bool repaint)
    {
        if(!repaint) return;                     //dont do anything, if we are not allowed to repaint because the level is terminating
        assert(overlayElement_);
        assert(this->background_);
        orxout()<< overlayElement_->getName()<< endl;
        //overlayElement_->hide();
        this->background_->removeChild(overlayElement_->getName());
        
    }
}
