
rotate_factor = 0
station_loc = 200
station_speed = 0

function spawn_station(obj)
	orxPrint("Spawning station")
	setPosition("Station", 500, 0, 0)
	setOrientation("Station", 0, -1, 0, 0)
end

function rotate_faster(obj1, obj2, health, shield)
	orxPrint("Rotating station faster")

	rotate_factor = rotate_factor + 0.02
	setAngularVelocity("Station", rotate_factor, 0, 0)
end


function kill_player()
	orxPrint("Killing player")
	killPawn("Player")
end

function kill_player_after_timeout(pawn)
	orxPrint("Killing player after 5s")

	registerAfterTimeout(kill_player, 5)
end

function next_station_loc(obj1, obj2)
	orxPrint("Moving station")

	station_loc = station_loc + 500
	setPosition("Station", station_loc, 0, 0)

	station_speed = station_speed + 5
	setVelocity("Station", -station_speed, 0, 0)

	registerAtNearObject(next_station_loc, "Player", "Station", 200)
end

orxPrint("Script started!")

registerAtAreaLeave(spawn_station, "Player", -300, -100, -100, 200, 200, 200)
registerAtPawnHit(rotate_faster, "Station")
registerAtPawnKilled(kill_player_after_timeout, "Station")
registerAtNearObject(next_station_loc, "Player", "Station", 200)

setAngularVelocity("Station", 0, 0, 0)

