#ifndef _DialogManager_H__
#define _DialogManager_H__

#include "DialogPrereqs.h"
#include "util/Singleton.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "core/object/Listable.h"
#include "Dialog.h"

#include <string>

namespace orxonox //tolua_export

{//tolua_export
    class _OrxonoxExport DialogManager //tolua_export
    : public Singleton<DialogManager>
    {//tolua_export
        friend class Singleton<DialogManager>;
    
        public:
        
        DialogManager(); 
        
        //gibt lua den pointer auf den Manager
        static DialogManager& getInstance() { return Singleton<DialogManager>::getInstance(); } //tolua_export

        //setzt den momentanen Dialog auf den uebergebenen, wird vom Dialog verwendet um bei Trigger event sich selbst zu setzen
        void setDialog(Dialog* dialog);

        //von hier an sind lua funktionalitaeten definiert

        //gibt den string der momentanen Frage des Dialogs
        std::string getQuestion(); //tolua_export

        //gibt die laenge des Antwort-arrays der momentanen zuruek, 0 falls es leer ist
        int getSize(); //tolua_export

        //gibt den sting zu einer Frage im antwortarray der momentanen Frage
        std::string getAnswer(int index); //tolua_export

        //gibt den Namen der Person mit der man spricht
        std::string getPerson(); //tolua_export

        //testet ob der dialog weiter geht, true wenn es keine weitere Frage nach der Antwort kommt oder keine Antwort zur Frage existiert
        bool endtest(int index); //tolua_export

        //updated den Dialog so dass er auf die Antwort die im Antwortvector am index steht reagiert
        void update(int index); //tolua_export

private:
    static DialogManager* singletonPtr_s;

    Dialog* currentTalk_;
    const std::vector<std::string>* answerIds_;

    };//tolua_export
}//tolua_export

#endif /* _DialogManager_H__ */