#ifndef _Dialog_H__
#define _Dialog_H__

#include "core/BaseObject.h"
#include "DialogPrereqs.h"
#include "Question.h"
#include "Answer.h"
#include "core/XMLPort.h"
#include "core/CoreIncludes.h"
#include "overlays/OrxonoxOverlay.h"

#include <map>
#include <vector>
#include <string>

namespace orxonox
{
	class _DialogExport Dialog : public BaseObject
	{
		public:
			Dialog(Context* context);

			virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
			virtual void XMLEventPort(Element& xmlelement, XMLPort::Mode mode);

			void setName(const std::string& name);	//xmlPort-Funktion, setzt Namen
			const std::string& getName() const;	//xmlPort-Funktion, returnt Namen

			void setCurrentQuestionId(const std::string& questionId);	//xmlPort-Funktion, setzt string Id der momentanen Frage
			const std::string& getCurrentQuestionId() const;	//xmlPort-Funktion, gibt Id der momentanen Frage

			void addQuestion(Question* question); //xmlPort-Funktion, fuegt Question der Map hinzu
			const Question* getQuestion() const; //xmlPort-Funktion, returnt nullptr

			void addAnswer(Answer* answer); //xmlPort-Funktion, fuegt Answer der Map hinzu
			const Answer* getAnswer(unsigned int index) const; //xmlPort-Funktion, returnt nullptr


			const std::vector<std::string>* getAnswerIds(); 	// returned Pointer auf Vector mit allen momentanen AntwortenIds

	 		bool execute(bool bTriggered, BaseObject* trigger); // funktion die aufgerufen wird wenn der im xml verbundene Trigger aktiviert wird

			void update(const std::string& givenAnswerId);	//setzt die naechste Frage entsprechend der gegebenen antwortId

			bool ending(const std::string& givenAnswerId); //ist true falls fuer die gegebene AntwortId keine Frage zur FragenId der Antwort existiert 

			const std::string& getQuestionString(); //gibt string der momentanen Frage 
			const std::string& getAnswerString(std::string answerId); //gibt string der zur Id passenden Frage

		private: 
			std::string name_;
			std::string currentQuestionId_;
			std::map<std::string, Question*> questions_;
			std::map<std::string, Answer*> answers_;
	};
}

#endif