#ifndef _Answer_H__
#define _Answer_H__

#include "core/BaseObject.h"
#include "DialogPrereqs.h"
#include "core/XMLPort.h"
#include "core/CoreIncludes.h"
#include <string>

namespace orxonox
{
	
	class _DialogExport Answer : public BaseObject
	{
		public:
			Answer(Context* context);
			
			virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);

			void setAnswerId(const std::string& answerId); //xmlPort-Funktion, setzt AntwortId
			const std::string& getAnswerId() const;	//xmlPort-Funktion,	gibt AntwortId

			void setNextQuestion(const std::string& nextId); //xmlPort-Funktion, um Dialog zu beenden tag benutzen der von keiner Frage benutzt wird
			const std::string& getNextQuestion() const;	//xmlPort-Funktion, gibt Id der Folgefrage

			void setAnswer(const std::string& awns);	//xmlPort-Funktion, setzt Antworttext
			const std::string& getAnswer() const;	//xmlPort-Funktion,	gibt Antworttext

		private:
			std::string answerId_;
			std::string answer_;
			std::string nextQuestionId_;
	};
}

#endif