#include "Answer.h"
#include "core/CoreIncludes.h"


namespace orxonox{

	RegisterClass(Answer);


	// Constructor:
	Answer::Answer(Context* context) : BaseObject(context) 
	{
	    RegisterObject(Answer);
	}

	void Answer::XMLPort(Element& xmlelement, XMLPort::Mode mode)
	{
		SUPER(Answer, XMLPort, xmlelement, mode);

		XMLPortParam(Answer, "Id", setAnswerId, getAnswerId, xmlelement, mode);
		XMLPortParam(Answer, "answer", setAnswer, getAnswer, xmlelement, mode);
		XMLPortParam(Answer, "nextQuestionId", setNextQuestion, getNextQuestion, xmlelement,mode);
	}

	void Answer::setAnswerId(const std::string& answerId){
		this->answerId_ = answerId;
	}

	const std::string& Answer::getAnswerId() const
	{
		return this->answerId_;
	}

	void Answer::setNextQuestion(const std::string& nextId)
	{
		this->nextQuestionId_ = nextId;
	}

	const std::string& Answer::getNextQuestion() const
	{
		return this->nextQuestionId_;
	}

	void Answer::setAnswer(const std::string& answer)
	{
		this->answer_ = answer;
	}

	const std::string& Answer::getAnswer() const
	{
		return this->answer_;
	}
}	