#ifndef _Question_H__
#define _Question_H__

#include "core/BaseObject.h"
#include "DialogPrereqs.h"
#include "AnswerId.h"
#include "core/XMLPort.h"
#include "core/CoreIncludes.h"


#include <string>

namespace orxonox
{
	class _DialogExport Question : public BaseObject
	{
		public:
			Question(Context* context);

			virtual void XMLPort(Element& xmelement, XMLPort::Mode mode);

			void setQuestionId(const std::string& Id);	//xmlPort-Funktion, setzt Id
			const std::string& getQuestionId() const;	//xmlPort-Funktion, gibt Id string zuruek

			void setQuestion(const std::string& question);	//xmlPort-Funktion, setzt Fragen string
			const std::string& getQuestion() const;	//xmlPort-Funktion, gibt Fragen string

			void addAnswerId(AnswerId* answerId); 	//xmlPort-Funktion, nimmt AnswerIds von entsprechenden Objekten und fuegt sie in List ein.
			const AnswerId* getAnswerId() const;	//xmlPort-Funktion, gibt nichts zuruek

			const std::vector<std::string>* getAnswerIds(); //returnt Pointer auf Vektor mit allen Ids



		private: 
			std::string questionId_;
			std::string question_;
			std::vector<std::string> answerIds_;
	};
}

#endif