#include "Question.h"
#include "core/CoreIncludes.h"

namespace orxonox
{

	RegisterClass(Question);

	Question::Question(Context* context) : BaseObject(context)
	{
		RegisterObject(Question);
	}

	void Question::XMLPort(Element& xmlement, XMLPort::Mode mode)
	{
		SUPER(Question, XMLPort, xmlement, mode);

		XMLPortParam(Question, "question", setQuestion, getQuestion, xmlement, mode);
		XMLPortParam(Question, "Id", setQuestionId, getQuestionId, xmlement, mode);

		XMLPortObject(Question, AnswerId, "answerIds", addAnswerId, getAnswerId, xmlement, mode);
	}

	void Question::setQuestionId(const std::string& Id)
	{
		this->questionId_ = Id;
	}

	const std::string& Question::getQuestionId() const
	{
		return this->questionId_;
	}

	void Question::setQuestion(const std::string& question)
	{
		this->question_ = question;
	}

	const std::string& Question::getQuestion() const
	{
		return this->question_;
	}

	void Question::addAnswerId(AnswerId* answerId)
	{
		this->answerIds_.push_back(answerId->getId());
	}

	const AnswerId* Question::getAnswerId() const
	{
		return nullptr;
	}

	const std::vector<std::string>* Question::getAnswerIds()
	{
		return &(this->answerIds_);
	}
	
}