#include "DialogManager.h"
#include "core/CoreIncludes.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include <string>

namespace orxonox {
	ManageScopedSingleton(DialogManager, ScopeID::ROOT, false);
	

	
	DialogManager::DialogManager()
	{
		this->currentTalk_ = nullptr;
	}

	void DialogManager::setDialog(Dialog* dialog)
	{
		this->currentTalk_ = dialog;
		answerIds_ = currentTalk_->getAnswerIds();	
	}

	//from here onward funcionality for lua axports

    std::string DialogManager::getQuestion()
    {
    	return this->currentTalk_->getQuestionString();
    }

    int DialogManager::getSize()
    {   
        return this->answerIds_->size();
    }

    std::string DialogManager::getAnswer(int index)
    {
    	return this->currentTalk_->getAnswerString(this->answerIds_->at(index));
    }
	
    std::string DialogManager::getPerson()
    {
    	return this->currentTalk_->getName();
    }

    bool DialogManager::endtest(int index)
    {   
        if(this->answerIds_->empty())
        {
            return true;
        }
        else 
        {
            return this->currentTalk_->ending(this->answerIds_->at(index));
        }

    }

    void DialogManager::update(int index)
    {
    	this->currentTalk_->update(answerIds_->at(index));
    	answerIds_ = this->currentTalk_->getAnswerIds();
    }
}
