#include "DialogManager.h"
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"
#include "Dialog.h"
#include "Question.h"


namespace orxonox
{

	RegisterClass(Dialog);
	
	//Constructor: 
	Dialog::Dialog(Context* context) : BaseObject(context)
	{
		RegisterObject(Dialog);
	}

	void Dialog::XMLPort(Element& xmlelement, XMLPort::Mode mode)
	{
		SUPER(Dialog, XMLPort, xmlelement, mode);

		XMLPortParam(Dialog, "name", setName, getName, xmlelement, mode);
		XMLPortParam(Dialog, "currentQuestionId", setCurrentQuestionId, getCurrentQuestionId, xmlelement, mode);
		XMLPortObject(Dialog, Question, "questions", addQuestion, getQuestion, xmlelement, mode);
		XMLPortObject(Dialog, Answer, "answers", addAnswer, getAnswer, xmlelement, mode);
	}

	void Dialog::XMLEventPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(Dialog, XMLEventPort, xmlelement, mode);

        XMLPortEventSink(Dialog, BaseObject, "execute", execute, xmlelement, mode); 
    }

	void Dialog::setName(const std::string& name)
	{
		this->name_ = name;
	}

	const std::string& Dialog::getName() const 
	{
		return this->name_;
	}

	void Dialog::setCurrentQuestionId(const std::string& questionId)
	{
		this->currentQuestionId_ = questionId;
	}

	const std::string& Dialog::getCurrentQuestionId() const
	{
		return this->currentQuestionId_;
	}


	void Dialog::addQuestion(Question* question) //fuegt Question der Map hinzu
	{
		this->questions_.insert(make_pair(question->getQuestionId(), question));
	}

	const Question* Dialog::getQuestion() const // returned nichts
	{
		return nullptr;
	}

	void Dialog::addAnswer(Answer* answer) //fuegt Answer der Map hinzu
	{
		this->answers_.insert(make_pair(answer->getAnswerId(), answer));
	}

	const Answer* Dialog::getAnswer(unsigned int index) const	//returned sting der Antwort zur Id.
	{
		return nullptr;
	}


	const std::vector<std::string>* Dialog::getAnswerIds() // returned vector mit allen momentanen AntwortenIds
	{
		
		Question* question = (this->questions_.find(this->currentQuestionId_))->second;
		const std::vector<std::string>* answers = question->getAnswerIds();
		return answers;
		
	} 
	
	bool Dialog::execute(bool bTriggered, BaseObject* trigger)
    {  
    	DialogManager& m = DialogManager::getInstance();
    	
    	if(questions_.count(this->currentQuestionId_)){
    		m.setDialog(this);
    		OrxonoxOverlay::showOverlay("Dialog");
    	}
    	else {
    		orxout() << "no start defined " << endl;
    	}
    	
        return false;
    }

    void Dialog::update(const std::string& givenAnswerId)
    {
    	Answer* answer = (answers_.find(givenAnswerId))->second;
    	this->currentQuestionId_ = answer->getNextQuestion();
    }

    bool Dialog::ending(const std::string& givenAnswerId)
    {
    	return !this->questions_.count(this->answers_.find(givenAnswerId)->second->getNextQuestion());
    }

	const std::string& Dialog::getQuestionString()
	{
		return this->questions_.find(this->currentQuestionId_)->second->getQuestion();
	}

	const std::string& Dialog::getAnswerString(std::string answerId)
	{
		return this->answers_.find(answerId)->second->getAnswer();
	}
}