#ifndef _Question_H__
#define _Question_H__

#include "core/BaseObject.h"
#include "DialogPrereqs.h"
#include "AnswerId.h"
#include "core/XMLPort.h"
#include "core/CoreIncludes.h"


#include <string>

namespace orxonox
{
	class _DialogExport Question : public BaseObject
	{
		public:
			Question(Context* context);

			virtual void XMLPort(Element& xmelement, XMLPort::Mode mode);

			void setQuestionId(std::string Id);
			std::string getQuestionId();

			void setQuestion(std::string question);
			std::string getQuestion();

			void addAnswerId(AnswerId* answerId); //leer lassen um Dialog zu beenden
			AnswerId* getAnswerId(unsigned int index) const;

			
			//braucht es getAnswerId oder reicht es andere funktion anzugeben,
			// die sowieso gebraucht wird?

			std::vector<std::string>* getAnswerIds(); //returnt vektor mit allen Ids



		private: 
			std::string questionId_;
			std::string question_;
			std::vector<std::string> answerIds_;
	};
}

#endif