#include "Question.h"
#include "core/CoreIncludes.h"

namespace orxonox
{

	RegisterClass(Question);

	Question::Question(Context* context) : BaseObject(context)
	{
		RegisterObject(Question);
	}

	void Question::XMLPort(Element& xmlement, XMLPort::Mode mode)
	{
		SUPER(Question, XMLPort, xmlement, mode);

		XMLPortParam(Question, "question", setQuestion, getQuestion, xmlement, mode);
		XMLPortParam(Question, "Id", setQuestionId, getQuestionId, xmlement, mode);

		XMLPortObject(Question, AnswerId, "answerIds", addAnswerId, getAnswerId, xmlement, mode);
	}

	void Question::setQuestionId(std::string Id)
	{
		this->questionId_ = Id;
	}

	std::string Question::getQuestionId()
	{
		return this->questionId_;
	}

	void Question::setQuestion(std::string question)
	{
		this->question_ = question;
	}

	std::string Question::getQuestion()
	{
		return this->question_;
	}

	void Question::addAnswerId(AnswerId* answerId)
	{
		this->answerIds_.push_back(answerId->getId());
	}

	AnswerId* Question::getAnswerId(unsigned int index) const
	{
		return nullptr;
	}

	std::vector<std::string>* Question::getAnswerIds()
	{
		return &(this->answerIds_);
	}
	
}