#ifndef _DialogManager_H__
#define _DialogManager_H__

#include "DialogPrereqs.h"
#include "util/Singleton.h"
#include "core/singleton/ScopedSingletonIncludes.h"
#include "core/object/Listable.h"
#include "Dialog.h"

#include <string>

namespace orxonox //tolua_export

{//tolua_export
    class _OrxonoxExport DialogManager //tolua_export
    : public Singleton<DialogManager>
    {//tolua_export
        friend class Singleton<DialogManager>;
    
        public:
        
        DialogManager(); 
        

        static DialogManager& getInstance() { return Singleton<DialogManager>::getInstance(); } //tolua_export

        void setDialog(Dialog* dialog);

        //from here on luafunctionality is declared

        std::string getQuestion(); //tolua_export
        int getSize(); //tolua_export
        std::string getAnswer(int index); //tolua_export
        std::string getPerson(); //tolua_export
        bool endtest(); //tolua_export
        void update(int index); //tolua_export

private:
    static DialogManager* singletonPtr_s;

    Dialog* currentTalk_;
    std::vector<std::string>* answerIds_;

    };//tolua_export
}//tolua_export

#endif /* _DialogManager_H__ */