#ifndef _Dialog_H__
#define _Dialog_H__

#include "core/BaseObject.h"
#include "DialogPrereqs.h"
#include "Question.h"
#include "Answer.h"
#include "core/XMLPort.h"
#include "core/CoreIncludes.h"
#include "overlays/OrxonoxOverlay.h"

#include <map>
#include <vector>
#include <string>

namespace orxonox
{
	class _DialogExport Dialog : public BaseObject
	{
		public:
			Dialog(Context* context);

			virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode);
			virtual void XMLEventPort(Element& xmlelement, XMLPort::Mode mode);

			void setName(std::string name);
			std::string getName();

			void setCurrentQuestionId(std::string questionId);
			std::string getCurrentQuestionId();

			void addQuestion(Question* question); //fuegt Question der Map hinzu
			void addAnswer(Answer* answer); //fuegt Answer der Map hinzu

			Question* getQuestion(unsigned int index) const; // // benoetigt fuer xmlPort
			Answer* getAnswer(unsigned int index) const; // benoetigt fuer xmlPort
			std::vector<std::string>* getAnswerIds(); 	// returned vector mit allen momentanen AntwortenIds

	 		bool execute(bool bTriggered, BaseObject* trigger);

			void update(std::string givenAnswer);

			bool ending(); //retruned true wenn die Id der Antwort end ist oder keine Antworten auf die frage eingetragen sind

			std::string getQuestionString(); //gibt string der momentanen Frage 
			std::string getAnswerString(std::string answerId); //gibt string der zur Id passenden Frage

		private: 
			std::string name_;
			std::string currentQuestionId_;
			std::map<std::string, Question*> questions_;
			std::map<std::string, Answer*> answers_;
	};
}

#endif