#include "DialogManager.h"
#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "core/EventIncludes.h"
#include "Dialog.h"
#include "Question.h"


namespace orxonox
{

	RegisterClass(Dialog);
	
	//Constructor: 
	Dialog::Dialog(Context* context) : BaseObject(context)
	{
		RegisterObject(Dialog);
	}

	void Dialog::XMLPort(Element& xmlelement, XMLPort::Mode mode)
	{
		SUPER(Dialog, XMLPort, xmlelement, mode);

		XMLPortParam(Dialog, "name", setName, getName, xmlelement, mode);
		XMLPortParam(Dialog, "currentQuestionId", setCurrentQuestionId, getCurrentQuestionId, xmlelement, mode);
		XMLPortObject(Dialog, Question, "questions", addQuestion, getQuestion, xmlelement, mode);
		XMLPortObject(Dialog, Answer, "answers", addAnswer, getAnswer, xmlelement, mode);
	}

	void Dialog::XMLEventPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(Dialog, XMLEventPort, xmlelement, mode);

        XMLPortEventSink(Dialog, BaseObject, "execute", execute, xmlelement, mode); 
    }

	void Dialog::setName(std::string name)
	{
		this->name_ = name;
	}

	std::string Dialog::getName() 
	{
		return this->name_;
	}

	void Dialog::setCurrentQuestionId(std::string questionId)
	{
		this->currentQuestionId_ = questionId;
	}

	std::string Dialog::getCurrentQuestionId()
	{
		return this->currentQuestionId_;
	}


	void Dialog::addQuestion(Question* question) //fuegt Question der Map hinzu
	{
		this->questions_.insert(make_pair(question->getQuestionId(), question));
	}

	void Dialog::addAnswer(Answer* answer) //fuegt Answer der Map hinzu
	{
		this->answers_.insert(make_pair(answer->getAnswerId(), answer));
	}

	Question* Dialog::getQuestion(unsigned int index) const // returned nichts
	{
		return nullptr;
		// Question question = (questions_.find(this->currentQuestionId_))->second;
		// return question.getQuestion();
	}

	Answer* Dialog::getAnswer(unsigned int index) const	//returned sting der Antwort zur Id.
	{
		return nullptr;
		// return (this->answers_.find(answerId))->second.getAnswer();
	}

	std::vector<std::string>* Dialog::getAnswerIds() // returned vector mit allen momentanen AntwortenIds
	{
		
		Question* question = (this->questions_.find(this->currentQuestionId_))->second;
		std::vector<std::string>* answers = question->getAnswerIds();
		return answers;
		
	} 
	
	bool Dialog::execute(bool bTriggered, BaseObject* trigger)
    {  
    	DialogManager& m = DialogManager::getInstance();
    	
    	if(questions_.count(this->currentQuestionId_)){
    		m.setDialog(this);
    		OrxonoxOverlay::showOverlay("Dialog");
    	}
    	else {
    		orxout() << "no start defined " << endl;
    	}
    	
        return false;
    }

    void Dialog::update(std::string givenAnswer)
    {
    	Answer* answer = (answers_.find(givenAnswer))->second;
    	this->currentQuestionId_ = answer->getNextQuestion();
    }

    bool Dialog::ending() //retruned true wenn die Id der Antwort end ist oder keine Antworten auf die frage eingetragen sind
    {
    	bool end = false;
    	if ((this->questions_.find(this->currentQuestionId_)->second)->getAnswerIds()->empty()){
    		end = true;
    	}	
    	return end;
    }

	std::string Dialog::getQuestionString()
	{
		return this->questions_.find(this->currentQuestionId_)->second->getQuestion();
	}

	std::string Dialog::getAnswerString(std::string answerId)
	{
		return this->answers_.find(answerId)->second->getAnswer();
	}
}