
#include "scriptable_controller_api.h"
#include "luatb.h"
#include "scriptable_controller.h"
#include "tools/Timer.h"

namespace orxonox
{

ScriptableControllerAPI::ScriptableControllerAPI(lua_State *lua, ScriptableController *controller)
{
    this->lua_ = lua;
    this->controller_ = controller;

    // Haven't found a shorter way yet to write that...
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::orxPrint)>::registerFunction<&ScriptableControllerAPI::orxPrint>(this, lua, "orxPrint");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAfterTimeout)>::registerFunction<&ScriptableControllerAPI::registerAfterTimeout>(this, lua, "registerAfterTimeout");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtNearObject)>::registerFunction<&ScriptableControllerAPI::registerAtNearObject>(this, lua, "registerAtNearObject");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtNearPoint)>::registerFunction<&ScriptableControllerAPI::registerAtNearPoint>(this, lua, "registerAtNearPoint");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtAreaEnter)>::registerFunction<&ScriptableControllerAPI::registerAtAreaEnter>(this, lua, "registerAtAreaEnter");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtAreaLeave)>::registerFunction<&ScriptableControllerAPI::registerAtAreaLeave>(this, lua, "registerAtAreaLeave");
//    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtObjectDestroyed)>::registerFunction<&ScriptableControllerAPI::registerAtObjectDestroyed>(this, lua, "registerAtObjectDestroyed");
//    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtPickup)>::registerFunction<&ScriptableControllerAPI::registerAtPickup>(this, lua, "registerAtPickup");

    // Checks for area enter, area leave and near object events
    this->areaCheckTimer.setTimer(0.5, true, createExecutor(createFunctor(&ScriptableControllerAPI::checkAreas, this)), false);
}

ScriptableControllerAPI::~ScriptableControllerAPI()
{
    lua_close(this->lua_);
}

void ScriptableControllerAPI::orxPrint(std::string msg)
{
    orxout(user_info) << msg << std::endl;
}

void ScriptableControllerAPI::registerAfterTimeout(std::function<void (void)> callback, double timeout)
{
    // Kills itself when the timer fires
    new Timer(timeout, false, callback, true);
}

void ScriptableControllerAPI::registerAtNearObject(std::function<void (std::string, std::string)> callback, std::string id1, std::string id2, double distance)
{
    WorldEntity *entity1 = this->controller_->getWorldEntityByID(id1);
    WorldEntity *entity2 = this->controller_->getWorldEntityByID(id2);

    if(entity1 != nullptr && entity2 != nullptr)
        this->nearObjectHandlers_.push_front(NearObjectHandler(entity1, entity2, id1, id2, distance, callback));
}

void ScriptableControllerAPI::registerAtNearPoint(std::function<void (std::string)> callback, std::string id, double x, double y, double z, double distance)
{
    WorldEntity *entity = this->controller_->getWorldEntityByID(id);

    if(entity != nullptr)
        this->nearPointHandlers_.push_front(NearPointHandler(entity, id, x, y, z, distance, callback));
}

void ScriptableControllerAPI::registerAtAreaEnter(std::function<void (std::string)> callback, std::string id, int x, int y, int z, int dx, int dy, int dz)
{
    WorldEntity *entity = this->controller_->getWorldEntityByID(id);

    if(entity != nullptr)
        this->areaHandlers_.push_front(AreaHandler(entity, id, x, y, z, dx, dy, dz, true, callback));
}

void ScriptableControllerAPI::registerAtAreaLeave(std::function<void (std::string)> callback, std::string id, int x, int y, int z, int dx, int dy, int dz)
{
    WorldEntity *entity = this->controller_->getWorldEntityByID(id);

    if(entity != nullptr)
        this->areaHandlers_.push_front(AreaHandler(entity, id, x, y, z, dx, dy, dz, false, callback));
}

void ScriptableControllerAPI::checkAreas()
{
    // Near object
    auto near_obj_handler = this->nearObjectHandlers_.begin();
    while(near_obj_handler != this->nearObjectHandlers_.end())
    {
        if((near_obj_handler->entity1_->getPosition() - near_obj_handler->entity2_->getPosition()).length() < near_obj_handler->distance_)
        {
            near_obj_handler->callback_(near_obj_handler->id1_, near_obj_handler->id2_);
            near_obj_handler = this->nearObjectHandlers_.erase(near_obj_handler);
        }
        else
        {
            near_obj_handler++;
        }
    }

    // Near point
    auto near_point_handler = this->nearPointHandlers_.begin();
    while(near_point_handler != this->nearPointHandlers_.end())
    {
        if((near_point_handler->entity_->getPosition() - near_point_handler->point_).length() < near_point_handler->distance_)
        {
            near_point_handler->callback_(near_point_handler->id_);
            near_point_handler = this->nearPointHandlers_.erase(near_point_handler);
        }
        else
        {
            near_point_handler++;
        }
    }

    // Areas
    auto area_handler = this->areaHandlers_.begin();
    while(area_handler != this->areaHandlers_.end())
    {
        if(area_handler->entity_->getPosition() > area_handler->start_point_ &&
           area_handler->entity_->getPosition() < area_handler->end_point_)
        {
            if(area_handler->atEnter_)
            {
                area_handler->callback_(area_handler->id_);
                area_handler = this->areaHandlers_.erase(area_handler);
            }
            else
            {
                area_handler++;
            }
        }
        else
        {
            if(!area_handler->atEnter_)
            {
                area_handler->callback_(area_handler->id_);
                area_handler = this->areaHandlers_.erase(area_handler);
            }
            else
            {
                area_handler++;
            }
        }
    }
}

}
