#ifndef SCRIPTABLE_CONTROLLER_H
#define SCRIPTABLE_CONTROLLER_H

#include <lua.hpp>
#include <string>
#include <list>
#include <map>
#include <memory>
#include "scriptable_controller_api.h"
#include "core/CoreIncludes.h"
#include "worldentities/WorldEntity.h"
#include "worldentities/ControllableEntity.h"
#include "tools/Timer.h"

struct lua_State;

namespace orxonox
{

class ScriptableController
{
public:
    int runScript(const std::string &file_path);

    void setPlayer(PlayerInfo *player);
    void registerWorldEntity(std::string id, WorldEntity *entity);
    void registerControllableEntity(std::string id, ControllableEntity *entity);

    WorldEntity *getWorldEntityByID(std::string id) const;
    ControllableEntity *getControllableEntityByID(std::string id) const;

private:
    std::list<std::unique_ptr<ScriptableControllerAPI> > apis_;
    PlayerInfo *player_;
    std::map<std::string, WorldEntity*> worldEntities_;
    std::map<std::string, ControllableEntity*> controllabelEntities_;

    void printLuaError(lua_State *lua);
};

}

#endif // SCRIPTABLE_CONTROLLER_H
