    /*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Theo von Arx
 *      Noah Zarro
 *   Co-authors:
 *      
 *
 */

/**
    @file SOBFireball.cc
    @brief Fireballs are the Projectile of the Fireflower Powerup
*/

#include "SOBFireball.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "SOBFigure.h"
#include "SOBGumba.h"
#include "SOB.h"    
#include "util/Output.h"
#include <BulletCollision/NarrowPhaseCollision/btManifoldPoint.h>



namespace orxonox
{
    RegisterClass(SOBFireball);

    SOBFireball::SOBFireball(Context* context) : MovableEntity(context)
    {
        RegisterObject(SOBFireball);

        attachedToFigure_ = false;
        setAngularFactor(0.0);
        figure_ = nullptr;
        this->enableCollisionCallback();
        gravityAcceleration_ = 5.0;
        speed_ = 0;
        hasCollided_=false;
        lastPos_ = getPosition();
        lastPos_.x -= 20;
        changeAllowed_ = true;
        changedOn_ = 0.0;
        goesRight_ = true;
        collDisX_ = 0;
        collDisZ_ = 0;

      orxout() << "fireball existed" << endl;

        
    }

    

    void SOBFireball::XMLPort(Element& xmlelement, XMLPort::Mode mode)
    {
        SUPER(SOBFireball, XMLPort, xmlelement, mode);
        XMLPortParam(SOBFireball, "speed", setSpeed, getSpeed, xmlelement, mode);


    }

    
    bool SOBFireball::collidesAgainst(WorldEntity* otherObject, const btCollisionShape* ownCollisionShape, btManifoldPoint& contactPoint) {
        collDisX_ = getPosition().x - contactPoint.getPositionWorldOnB().getX();
        collDisZ_ = getPosition().z - contactPoint.getPositionWorldOnB().getZ();

        SOBGumba* gumba = orxonox_cast<SOBGumba*>(otherObject);

        if(gumba!=nullptr && !(gumba->hasCollided_)) //if other object is a Gumba, kill the Gumba and add score and destroy the fireball
        {
            gumba->destroyLater();
            gumba->hasCollided_ = true;
            SOB* SOBGame = orxonox_cast<SOB*>(getGametype());
            SOBGame->addGumba();
            this->destroyLater();
            this->hasCollided_ = true;
        }
         //collision with either top or bottom of a block
        else if(changeAllowed_ && (abs(collDisX_)<=abs(collDisZ_)))
        {
            changeAllowed_ = false;
            Vector3 velocity = getVelocity();
            orxout() << "before:    velocity in z = " << velocity.z << endl;
            velocity.z = -velocity.z;
            orxout() << "after:     velocity in z = " << velocity.z << endl;

            setVelocity(velocity);
        }

        //collision with the vertical side of a block 
        else if(changeAllowed_ && (abs(collDisX_)>abs(collDisZ_))) 
        {
            orxout() << "collision with the vertical side of a block " << endl;

            changeAllowed_ = false;
            goesRight_=!goesRight_;
        }

        
        return true;
    }


    void SOBFireball::setFigure(SOBFigure* newFigure)
    {
        figure_ = newFigure;
    }



    void SOBFireball::tick(float dt)
    {
        SUPER(SOBFireball, tick, dt);

        if (!changeAllowed_) {
            changedOn_+= dt;
            // After a collision, we don't listen for collisions for 200ms - that's because one wall can cause several collisions!
            if (changedOn_> 0.100) {
                changeAllowed_ = true;
                changedOn_ = 0.0;

            }
        
        }
            int dir = 1;
            if (!goesRight_)
                dir = -1;

            Vector3 velocity = getVelocity();
            velocity.z -= gravityAcceleration_*dt;
            velocity.x = dir*speed_;
            setVelocity(velocity);

            lastPos_ = getPosition();
        
    }
    


}
