
#include "scriptable_controller_api.h"
#include "luatb.h"
#include "scriptable_controller.h"

namespace orxonox
{

ScriptableControllerAPI::ScriptableControllerAPI(lua_State *lua, ScriptableController *controller)
{
    this->lua_ = lua;
    this->controller_ = controller;

    // Haven't found a shorter way yet to write that...
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAfterTimeout)>::registerFunction<&ScriptableControllerAPI::registerAfterTimeout>(this, lua, "registerAfterTimeout");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtNearObject)>::registerFunction<&ScriptableControllerAPI::registerAtNearObject>(this, lua, "registerAtNearObject");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtAreaEnter)>::registerFunction<&ScriptableControllerAPI::registerAtAreaEnter>(this, lua, "registerAtAreaEnter");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtAreaLeave)>::registerFunction<&ScriptableControllerAPI::registerAtAreaLeave>(this, lua, "registerAtAreaLeave");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtObjectDestroyed)>::registerFunction<&ScriptableControllerAPI::registerAtObjectDestroyed>(this, lua, "registerAtObjectDestroyed");
    LuaTB<ScriptableControllerAPI, decltype(&ScriptableControllerAPI::registerAtPickup)>::registerFunction<&ScriptableControllerAPI::registerAtPickup>(this, lua, "registerAtPickup");
}

ScriptableControllerAPI::~ScriptableControllerAPI()
{
    lua_close(this->lua_);
}

void ScriptableControllerAPI::registerAfterTimeout(std::function<void (void)> callback, double timeout)
{
    // TODO Extend timer class to accept std::function
    this->controller_->registerTimeout(callback, timeout);
}

int ScriptableControllerAPI::registerAtNearObject(std::function<void (int, int)> callback, int obj1, int obj2, double distance)
{

}

int ScriptableControllerAPI::registerAtAreaEnter(std::function<void (int)> callback, int obj, int x, int y, int z, int dx, int dy, int dz)
{

}

int ScriptableControllerAPI::registerAtAreaLeave(std::function<void (int)> callback, int obj, int x, int y, int z, int dx, int dy, int dz)
{

}

int ScriptableControllerAPI::registerAtObjectDestroyed(std::function<void (int)> callback, int obj)
{

}

int ScriptableControllerAPI::registerAtPickup(std::function<void (int)> callback, int pickup_id)
{

}

}
