
#include "luatb_typed_stack.h"
#include "luatb.h"
#include <string>

// Holds a list of all current callback references
std::list<std::unique_ptr<int> > LuaTBTypedStack::callbackRefs = {};

// Explicit and full specializations need to be in a .cpp file

template<>
int LuaTBTypedStack::getFromLuaStack<int>(lua_State *lua)
{ return lua_tointeger(lua, lua_gettop(lua)); }

template<>
double LuaTBTypedStack::getFromLuaStack<double>(lua_State *lua)
{ return lua_tonumber(lua, lua_gettop(lua)); }

template<>
std::string LuaTBTypedStack::getFromLuaStack<std::string>(lua_State *lua)
{ return lua_tostring(lua, lua_gettop(lua)); }

template<>
void LuaTBTypedStack::pushToLuaStack<int>(lua_State *lua, int value)
{ lua_pushinteger(lua, value); }

template<>
void LuaTBTypedStack::pushToLuaStack<double>(lua_State *lua, double value)
{ lua_pushnumber(lua, value); }

template<>
void LuaTBTypedStack::pushToLuaStack<std::string>(lua_State *lua, std::string value)
{ lua_pushstring(lua, value.c_str()); }
