/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Florian Zinggeler
 *   Co-authors:
 *      ...
 *
 */

/**
    @file FlappyOrxShip.cc
    @brief Implementation of the FlappyOrxShip class.
*/

#include "FlappyOrxShip.h"

#include "core/CoreIncludes.h"
#include "core/XMLPort.h"
#include "FlappyOrx.h"
#include "graphics/Camera.h"
#include "weapons/projectiles/Projectile.h"
#include <math.h> 

namespace orxonox
{
    RegisterClass(FlappyOrxShip);

    FlappyOrxShip::FlappyOrxShip(Context* context) : SpaceShip(context)
    {
        RegisterObject(FlappyOrxShip);

        this->UpwardThrust = 1;
        this->speed = 1;
        this->gravity = 1;
        
    }
    void FlappyOrxShip::XMLPort(Element& xmlelement, XMLPort::Mode mode)
        {   
            SUPER(FlappyOrxShip, XMLPort, xmlelement, mode);
            XMLPortParam(FlappyOrxShip, "speed", setSpeed, getSpeed, xmlelement, mode);
            XMLPortParam(FlappyOrxShip, "UpwardThrust", setUpwardThrust, getUpwardThrust, xmlelement, mode);
            XMLPortParam(FlappyOrxShip, "gravity", setGravity, getGravity, xmlelement, mode);
    }

    void FlappyOrxShip::tick(float dt)
    {
        SUPER(FlappyOrxShip, tick, dt);
        //Execute movement
        if (this->hasLocalController())
        {
            if(getHealth()<0){
                setHealth(1);
                getGame()->death();
                death();   
            }
            Vector3 pos = getPosition();

            getGame()->updatePlayerPos(pos.x);
            

            velocity.y += gravity*dt;
            if(isFlapping){
                isFlapping = false;
                if(pos.z > -150)
                    velocity.y = -UpwardThrust;
            }

            pos += Vector3(speed + velocity.x, 0, velocity.y) * dt;
            

            
            // Camera
            Camera* camera = this->getCamera();
            if (camera != nullptr)
            {
                //camera->setPosition(Vector3(-pos.z, -pos.y, 0));
                camera->setPosition(pos.x,-100,0);
                camera->setOrientation(Vector3::UNIT_Z, Degree(0));

            }

            
            setPosition(pos);
            setOrientation(Vector3::UNIT_Y, Degree(270-velocity.y/10));

            if(pos.z > 150){
                getGame()->death();
                death();
            }
            
        }
    }

    void FlappyOrxShip::updateLevel()
    {
        if (getGame())
            getGame()->levelUp();
    }

    void FlappyOrxShip::moveFrontBack(const Vector2& value)
    {

    }

    void FlappyOrxShip::moveRightLeft(const Vector2& value){}

    void FlappyOrxShip::boost(bool boost){
        isFlapping=boost;
    }

    void FlappyOrxShip::rotateRoll(const Vector2& value)
    {
        if (getGame())
            if (getGame()->bEndGame)
                getGame()->end();
    }

    FlappyOrx* FlappyOrxShip::getGame()
    {
        if (game == nullptr)
        {
            for (FlappyOrx* flappyOrx : ObjectList<FlappyOrx>())
                game = flappyOrx;
        }
        return game;
    }

    void FlappyOrxShip::death()
    {
        Vector3 pos = getPosition();
        pos.x = 0;
        pos.z = 0;
        pos.y = 0;
        velocity.y = 0;
        setPosition(pos);
        usleep(1000u);
    }
}
