#ifndef SCRIPTABLE_CONTROLLER_API_H
#define SCRIPTABLE_CONTROLLER_API_H

#include <functional>
#include "core/CoreIncludes.h"

// TODO Is pos int or double?

struct lua_State;

namespace orxonox
{

class ScriptableController;

class ScriptableControllerAPI
{
public:
    ScriptableControllerAPI(lua_State *lua, ScriptableController *controller);
    ~ScriptableControllerAPI();

    void testOutput(void);

    void registerAfterTimeout(std::function<void (void)> callback, int timeout_ms);
    int registerAtNearObject(std::function<void(int, int)> callback, int obj1, int obj2, double distance);
    int registerAtAreaEnter(std::function<void (int)> callback, int obj, int x, int y, int z, int dx, int dy, int dz);
    int registerAtAreaLeave(std::function<void (int)> callback, int obj, int x, int y, int z, int dx, int dy, int dz);
    int registerAtObjectDestroyed(std::function<void (int)> callback, int obj);
    int registerAtPickup(std::function<void (int)> callback, int pickup_id);

    int destroyObject(int obj);
    void removeObject(int obj);
    int setObjectPosition(int obj, double x, double y, double z);

    static ScriptableControllerAPI *this_;

private:
    lua_State *lua_;
    ScriptableController *controller_;
};

}

#endif // SCRIPTABLE_CONTROLLER_API_H
