#ifndef SCRIPTABLE_CONTROLLER_H
#define SCRIPTABLE_CONTROLLER_H

#include <lua.hpp>
#include <string>
#include <list>
#include <map>
#include <memory>
#include "scriptable_controller_api.h"
#include "core/CoreIncludes.h"
#include "worldentities/WorldEntity.h"
#include "worldentities/ControllableEntity.h"

struct lua_State;

namespace orxonox
{

class ScriptableController
{
public:
    int runScript(const std::string &file_path);

    void registerWorldEntity(int id, WorldEntity *obj);
    void registerControllableEntity(int id, ControllableEntity *obj);

    WorldEntity *getWorldEntityByID(int id) const;
    ControllableEntity *getControllableEntityByID(int id) const;

private:
    std::list<std::unique_ptr<ScriptableControllerAPI> > apis_;
    ControllableEntity *player_; // TODO
    std::map<int, WorldEntity*> worldEntities_;
    std::map<int, ControllableEntity*> controllabelEntities_;

    void printLuaError(lua_State *lua);
};

}

#endif // SCRIPTABLE_CONTROLLER_H
