
#include "luatb_typed_stack.h"
#include <string>

// Explicit and full specializations need to be in a .cpp file

template<>
int LuaTBTypedStack::popFromLuaStack<int>(lua_State *lua)
{ return lua_tointeger(lua, lua_gettop(lua)); }

template<>
double LuaTBTypedStack::popFromLuaStack<double>(lua_State *lua)
{ return lua_tonumber(lua, lua_gettop(lua)); }

template<>
std::string LuaTBTypedStack::popFromLuaStack<std::string>(lua_State *lua)
{ return lua_tostring(lua, lua_gettop(lua)); }

template<>
void LuaTBTypedStack::pushToLuaStack<int>(lua_State *lua, int value)
{ lua_pushinteger(lua, value); }

template<>
void LuaTBTypedStack::pushToLuaStack<double>(lua_State *lua, double value)
{ lua_pushnumber(lua, value); }

template<>
void LuaTBTypedStack::pushToLuaStack<std::string>(lua_State *lua, std::string value)
{ lua_pushstring(lua, value.c_str()); }
