#ifndef LUATB_H
#define LUATB_H

#include <string>

struct lua_State;

// Makes certain functions visible to lua while staying type-safe on the
// C++ side.
template<typename ThisType, typename FunctionType>
class LuaTB
{
public:
    // Make a function visible to lua. If you want to make a function 'foo'
    // visible, you should call it like this:
    //
    // LuaWrapper<decltype(foo)>::registerFunction<foo>( ... );
    template<FunctionType func>
    static void registerFunction(ThisType *_this, lua_State *lua, std::string name);
};

// We need to include all type-dependant template implementations, because the
// compiler needs to know for which types it has to instantiate those
#include "luatb.ipp"

#endif // LUATB_H
