#ifndef IS_CALLABLE_H
#define IS_CALLABLE_H

#include <type_traits>

// See https://stackoverflow.com/a/15396757/7421666
template<typename T>
struct IsCallableImpl
{
private:
    typedef char(&yes)[1];
    typedef char(&no)[2];

    struct Fallback { void operator()(); };
    struct Derived : T, Fallback { };

    template<typename U, U> struct Check;

    template<typename>
    static yes test(...);

    template<typename C>
    static no test(Check<void (Fallback::*)(), &C::operator()>*);

public:
    static const bool value = sizeof(test<Derived>(0)) == sizeof(yes);
};

// Checks if a type is callable (has an 'operator()'). This will not work for
// normal functions without modifications, but we don't need that case anyway.
template<typename T>
struct IsCallable
    : std::conditional<
        std::is_class<T>::value,
        IsCallableImpl<T>,
        std::false_type
    >::type
{ };

#endif // IS_CALLABLE_H
