#include "Waypoint.h"

#include <OgreSceneNode.h>
#include <BulletDynamics/Dynamics/btRigidBody.h>
#include "util/OrxAssert.h"
#include "core/CoreIncludes.h"

namespace orxonox
{
    RegisterClass(Waypoint);

    Waypoint::Waypoint(Context* context) : StaticEntity(context)
    {
        RegisterObject(Waypoint);
        model = new Model(this->getContext());
        model->setMeshSource("cube.mesh");  // Name of the arrow file for now bottle
        this->attach(model);
        model->setScale(3);
        //model->setOrientation(Vector3(0,0,-1));
        model->setPosition(Vector3(0.0,0.0,0.0));        // this is wrong, it has to be triggered
        waypoint_active = false;
        distancetrigger = new DistanceTrigger(this->getContext());   
        distancetrigger->setDistance(100);
        this->attach(distancetrigger);
    }

    Waypoint::~Waypoint()
    {
    }


     //WorldEntity::setDirection
     //WorldEntity::getPosition()
     //setOrientation()


    void Waypoint::XMLPort(Element& xmlelement, XMLPort::Mode mode){
        SUPER(Waypoint, XMLPort, xmlelement, mode); // From the SpaceShip.cc file
        XMLPortParam(Waypoint, "order", getOrder, setOrder, xmlelement, mode);

    }


}
