/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Johannes Ritz
 *   Co-authors:
 *      ...
 *
 */

#ifndef _Dynamicmatch_H__
#define _Dynamicmatch_H__

#include "OrxonoxPrereqs.h"

#include <map>
#include <set>
#include <vector>

#include "tools/Timer.h"

#include "Gametype.h"

namespace orxonox
{
    /**
    @brief
        Short Gaming Manual:
        There are three different parties a player can belong to: victim, chaser or killer
        Every player starts as chaser. As long as there are not enough victims and killers, you can change your and other player's parties by shooting them.
        In order to win you have to earn as much points as possible:
        - as victim by escaping the chasers
        - as chaser by shooting the victim
        - as killer by killing the chasers


        What you shouldn't do is shooting at players of your own party. By doing so your score will decrease.
        P.S: If you don't want to be a victim: Get rid of your part by shooting a chaser.

        @todo:
        pig punkte vergeben pro Zeit!
        killerfarbe schwarz; evtl. eigenes Raumfahrzeug;
        Low; Codeoptimierung und Dokumentation
    */
    class _OrxonoxExport Dynamicmatch : public Gametype
    {
        public:
            Dynamicmatch(Context* context);
            virtual ~Dynamicmatch();

            bool notEnoughPigs;
            bool notEnoughKillers;
            bool notEnoughChasers;

            //three different parties
            int chaser;
            int piggy;
            int killer;

            virtual void evaluatePlayerParties();
            int getParty(PlayerInfo* player);
            void setPlayerColour(PlayerInfo* player);//own function
            void setConfigValues();//done

            bool friendlyfire; //goal: player can switch it on/off
            bool tutorial; //goal: new players receive messages how the new gametype works - later it can be switched off.

            virtual bool allowPawnDamage(Pawn* victim, Pawn* originator = nullptr) override; //ok - score function and management of parties
            virtual bool allowPawnDeath(Pawn* victim, Pawn* originator = nullptr) override; //ok - simple
            virtual void start() override;
            virtual void end() override; //Wie geht das mit der Punkteausgabe aendern? Z.B: Persoenliche Nachricht?
            virtual void playerEntered(PlayerInfo* player) override;
            virtual void playerStartsControllingPawn(PlayerInfo* player, Pawn* pawn) override;//is used to initialize the player's party and colour
            virtual bool playerLeft(PlayerInfo* player) override;
            virtual bool playerChangedName(PlayerInfo* player) override;//unchanged

            /*virtual void instructions();
            virtual void furtherInstructions();*/
            virtual void rewardPig();
            void grantPigBoost(SpaceShip* spaceship); // Grant the piggy a boost.
            void resetSpeedFactor(SpaceShip* spaceship, Timer* timer);
            virtual void tick (float dt) override;// used to end the game
            virtual SpawnPoint* getBestSpawnPoint(PlayerInfo* player) const override;


        protected:
            inline unsigned int getPlayerCount() const
                 { return this->numberOf[chaser] + numberOf[piggy] + this->numberOf[killer]; }

            std::map< PlayerInfo*, int > playerParty_; //player's parties are recorded here
            std::vector<ColourValue> partyColours_; //aus TeamDeathmatch
            std::set<Timer*> piggyTimers_;
            unsigned int numberOf[3]; //array to count number of chasers, pigs, killers
            float pointsPerTime;
            float gameTime_;   // from UnderAttack
            bool gameEnded_; // true if game is over
            int timesequence_; //used for countdown
            //Timer callInstructions_;
    };
}

#endif /* _Dynamicmatch_H__ */
