/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      ...
 *
 */

#ifndef _MasterController_H__
#define _MasterController_H__

#include "controllers/Controller.h"
#include "controllers/ActionpointController.h"
#include "tools/interfaces/Tickable.h"



namespace orxonox
{
    /**
    @brief
      calles action(), maneuver() and canFire() methods of all the ActionpointControllers in level.
      Only one instance of MasterController is to be placed in level.
      If no MasterController is initialized, none of ActionpointControllers will work.
      Example:

      @code
      <Pawn position = "100000, 100000, 100000">
        <controller>
          <MasterController>
          </MasterController>
        </controller>
      </Pawn>
      @endcode
    */
    class _OrxonoxExport MasterController : public Controller, public Tickable
    {
        public:
            //----[language demanded functions]----            
                MasterController(Context* context);

                virtual ~MasterController();
            //----[/language demanded functions]----            

            //----[orxonox demanded functions]----
                virtual void tick(float dt) override;

            //----[orxonox demanded functions]----

        protected:
          
        private:
            std::vector<WeakPtr<ActionpointController>> controllers_;//<! vector of controllers, which action(), canFire() and maneuver() methods are to be called
            size_t indexOfCurrentController_;                        //<! index of current controller
            unsigned int numberOfTicksPassedSinceLastActionCall_;
            unsigned int ticks_;                                     //<! local tick counter            

    };
}

#endif /* _MasterController_H__ */
