/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Gani Aliguzhinov
 *   Co-authors:
 *      Fabian 'x3n' Landau, Dominik Solenicki
 *
 */

#ifndef _FightingController_H__
#define _FightingController_H__


#include "controllers/FlyingController.h"

namespace orxonox
{
    /**
    @brief
        FightingController stores all the fighting methods and member variables of AI.
        Main methods here are maneuver() and dodge().
    
    @note
        ActionpointController will not work, if there is no MasterController in the level!
    */
    class _OrxonoxExport FightingController : public FlyingController
    {

        public:
            FightingController(Context* context);
            virtual ~FightingController();
            
            float squaredDistanceToTarget() const;
            bool isLookingAtTarget(float angle) const;
            bool hasTarget() const;
            ControllableEntity* getTarget() const
                { return this->target_; }
            bool bKeepFormation_;   //even if action_ == FIGHT, you might still want to keep formation if far enough form the target
            virtual void maneuver(); //<! sets this->targetPosition_, which is a Vector3 of where this ship flies. Decision is made based on
                             //<! the distance to enemy, if being attacked, dodge() is called, otherwise ship just flies towards this->target_.
            bool bShooting_;    //<! if true, ship shoots each tick
            bool canFire(); //<! check if target_ is in radius and if this is looking at target_
        protected:
            void setTarget(ControllableEntity* target); //set a target to shoot at

            void setPositionOfTarget(const Vector3& target);    //good to know where target is
            void setOrientationOfTarget(const Quaternion& orient);  //I don't really use that
            void stopLookingAtTarget();     //<! target dead -> you need to be able to fly
            void startLookingAtTarget();    //<! if close to target, no need to fly, just rotate yourself
            void lookAtTarget(float dt);    //<! rotate yourself towards target

            void dodge(const Vector3& thisPosition, float diffLength,  Vector3& diffUnit); //<! choose a random Vector3 perpendicular to the difference vector between
                                                                        //<! this and target_ plus or minus some amount in difference vector direction,
                                                                        //<! depending on whether it is better to close up or survive.
            void doFire();  //<! choose weapon, set aim at target_ and fire
            WeakPtr<ControllableEntity> target_;
            void setClosestTarget();
         
            bool bHasPositionOfTarget_;
            Vector3 positionOfTarget_;
            bool bHasOrientationOfTarget_;
            Quaternion orientationOfTarget_;
            Pawn* closestTarget() const;

            bool bDodge_;
            int attackRange_;
            bool bLookAtTarget_; 
            float deltaHp;
            float previousHp;
            bool bStartedDodging_;
            //WEAPONSYSTEM DATA
            int rocketsLeft_;
            int timeout_;
            bool bFiredRocket_;
            std::map<std::string, int> weaponModes_; //<! Links each "weapon" to it's weaponmode - managed by setupWeapons()
            //std::vector<int> projectiles_; //<! Displays amount of projectiles of each weapon. - managed by setupWeapons()
            void setupWeapons(); //<! Defines which weapons are available for a bot. Is recalled whenever a bot was killed.
            bool bSetupWorked; //<! If false, setupWeapons() is called.
            int getFiremode(const std::string& name);
          
    };
}

#endif /* _FightingController_H__ */
