/*
 *   ORXONOX - the hottest 3D action shooter ever to exist
 *                    > www.orxonox.net <
 *
 *
 *   License notice:
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation; either version 2
 *   of the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *   Author:
 *      Fabien Vultier
 *      Jannis Holzer
 *   Co-authors:
 *      ...
 *
 */

/**
    @file MineGun.h
    @brief

    Mine is a weapon that explodes if a spaceship goes bellow the mines trigger radius. The mine deals damage too all
    spaceships within the damageradius.

    The activation time regulates when the mine is live and ready to explode.
    The mine destroys itself after it exceeds a certain life time.
*/

#ifndef _MineGun_H__
#define _MineGun_H__

#include "weapons/WeaponsPrereqs.h"
#include "weaponsystem/WeaponMode.h"

namespace orxonox
{

    /**
    @brief
        A Weapon that drops mines to space.
    @ingroup WeaponsWeaponModes
    */
    class _WeaponsExport MineGun : public WeaponMode
    {
        public:
            MineGun(Context* context);
            virtual ~MineGun();

            virtual void XMLPort(Element& xmlelement, XMLPort::Mode mode) override;
            virtual void fire() override;

            inline float getMaxTimeUntilExplosion() const
                { return this->maxTimeUntilExplosion_; }
            inline float getTimeUntilActivation() const
                { return this->timeUntilActivation_; }
        protected:
            inline void setMaxTimeUntilExplosion(float maxTimeUntilExplosion)
                { this->maxTimeUntilExplosion_ = maxTimeUntilExplosion; }
            inline void setTimeUntilActivation(float timeUntilActivation)
                { this->timeUntilActivation_ = timeUntilActivation; }
        private:
            float speed_; //The speed of the fired projectile.
            float maxTimeUntilExplosion_;
            float timeUntilActivation_;
    };
}

#endif /* _MineGun_H__ */
